/*************************************************************************/
/*                                                                       */
/*  Copyright (c) 1994 Stanford University                               */
/*                                                                       */
/*  All rights reserved.                                                 */
/*                                                                       */
/*  Permission is given to use, copy, and modify this software for any   */
/*  non-commercial purpose as long as this copyright notice is not       */
/*  removed.  All other uses, including redistribution in whole or in    */
/*  part, are forbidden without prior written permission.                */
/*                                                                       */
/*  This software is provided with absolutely no warranty and no         */
/*  support.                                                             */
/*                                                                       */
/*************************************************************************/


/**************************************************************
 *
 *       Parallel Hierarchical Radiosity
 *
 *
 *       Room model data base.
 *
 *       Courtesy of Pat Hanrahan.
 *
 ***************************************************************/

EXTERN_ENV;

#include <stdio.h>

include(radiosity.h)


ModelDataBase room_model[] =
{

    /** Patch 0 **/
    { MODEL_RECTANGLE,
        { { 0.615686, 0.737255, 0.870588 }, { 0.000000, 0.000000, 0.000000 },
            { { 847.000000, -800.002014, 700.000000 },
                { -847.000000, -800.002014, 700.000000 },
                { 847.000000, 800.002014, 700.000000 } } } },

    /** Patch 1 **/
    { MODEL_RECTANGLE,
        { { 0.615686, 0.737255, 0.870588 }, { 0.000000, 0.000000, 0.000000 },
            { { -847.000000, -800.002014, -1001.000000 },
                { 847.000000, -800.002014, -1001.000000 },
                { -847.000000, 800.002014, -1001.000000 } } } },

    /** Patch 2 **/
    { MODEL_RECTANGLE,
        { { 0.615686, 0.737255, 0.870588 }, { 0.000000, 0.000000, 0.000000 },
            { { 847.000000, -800.002014, -1001.000000 },
                { 847.000000, -800.002014, 700.000000 },
                { 847.000000, 800.002014, -1001.000000 } } } },

    /** Patch 3 **/
    { MODEL_RECTANGLE,
        { { 0.615686, 0.737255, 0.870588 }, { 0.000000, 0.000000, 0.000000 },
            { { -847.000000, -800.002014, 700.000000 },
                { -847.000000, -800.002014, -1001.000000 },
                { -847.000000, 800.002014, 700.000000 } } } },

    /** Patch 4 **/
    { MODEL_RECTANGLE,
        { { 0.603921, 0.603921, 0.603921 }, { 0.000000, 0.000000, 0.000000 },
            { { 847.000000, 800.002014, 700.000000 },
                { -847.000000, 800.002014, 700.000000 },
                { 847.000000, 800.002014, -1001.000000 } } } },

    /** Patch 5 **/
    { MODEL_RECTANGLE,
        { { 0.501961, 0.501961, 0.501961 }, { 0.000000, 0.000000, 0.000000 },
            { { 847.000000, -800.002014, -1001.000000 },
                { -847.000000, -800.002014, -1001.000000 },
                { 847.000000, -800.002014, 700.000000 } } } },

    /** Patch 6 **/
    { MODEL_RECTANGLE,
        { { 0.576470, 0.521569, 0.521568 }, { 0.000000, 0.000000, 0.000000 },
            { { -269.149994, -216.666794, -1001.000000 },
                { 165.895096, -216.666794, -1001.000000 },
                { -269.149994, 281.666687, -1001.000000 } } } },

    /** Patch 7 **/
    { MODEL_RECTANGLE,
        { { 0.098034, 0.086275, 0.074510 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -159.999695, 285.980103 },
                { -840.000061, -159.999695, -404.214966 },
                { -840.000061, 298.332977, 285.980103 } } } },

    /** Patch 8 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -84.000000, -350.000000, -999.999023 },
                { -840.000061, -350.000000, -159.998962 },
                { -84.000000, -299.999695, -999.999023 } } } },

    /** Patch 9 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -350.000000, -159.998962 },
                { -84.000000, -350.000000, -999.999023 },
                { -336.000000, -350.000000, 155.000305 } } } },

    /** Patch 10 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -336.000000, -299.999695, 155.000305 },
                { 420.000031, -299.999695, -684.999023 },
                { -840.000061, -299.999695, -159.998962 } } } },

    /** Patch 11 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -336.000000, -350.000000, 155.000305 },
                { 420.000031, -350.000000, -684.999023 },
                { -336.000000, -299.999695, 155.000305 } } } },

    /** Patch 12 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 420.000031, -350.000000, -684.999023 },
                { -84.000000, -350.000000, -999.999023 },
                { 420.000031, -299.999695, -684.999023 } } } },

    /** Patch 13 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -350.000000, -159.998962 },
                { -336.000000, -350.000000, 155.000305 },
                { -840.000061, -299.999695, -159.998962 } } } },

    /** Patch 14 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -306.000092, -800.002014, 80.000183 },
                { -786.001953, -800.002014, -220.003052 },
                { -306.000092, -350.000000, 80.000183 } } } },

    /** Patch 15 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -341.999695, -800.002014, 120.000305 },
                { -306.000092, -800.002014, 80.000183 },
                { -341.999695, -350.000000, 120.000305 } } } },

    /** Patch 16 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -786.001953, -800.002014, -220.003052 },
                { -822.002930, -800.002014, -179.998047 },
                { -786.001953, -350.000000, -220.003052 } } } },

    /** Patch 17 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -822.002930, -800.002014, -179.998047 },
                { -341.999695, -800.002014, 120.000305 },
                { -822.002930, -350.000000, -179.998047 } } } },

    /** Patch 18 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.999901, -533.332825, -345.001953 },
                { 420.000031, -533.332825, -684.999023 },
                { 113.999901, -500.000214, -345.001953 } } } },

    /** Patch 19 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 420.000031, -533.332825, -684.999023 },
                { -84.000000, -533.332825, -999.999023 },
                { 420.000031, -500.000214, -684.999023 } } } },

    /** Patch 20 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.999901, -500.000214, -345.001953 },
                { 420.000031, -500.000214, -684.999023 },
                { -390.000092, -500.000214, -660.001953 } } } },

    /** Patch 21 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -390.000092, -533.332825, -660.001953 },
                { -84.000000, -533.332825, -999.999023 },
                { 113.999901, -533.332825, -345.001953 } } } },

    /** Patch 22 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -84.000000, -533.332825, -999.999023 },
                { -390.000092, -533.332825, -660.001953 },
                { -84.000000, -500.000214, -999.999023 } } } },

    /** Patch 23 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -390.000092, -533.332825, -660.001953 },
                { 113.999901, -533.332825, -345.001953 },
                { -390.000092, -500.000214, -660.001953 } } } },

    /** Patch 24 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.999901, -700.000000, -345.001953 },
                { 420.000031, -700.000000, -684.999023 },
                { 113.999901, -666.666687, -345.001953 } } } },

    /** Patch 25 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 420.000031, -700.000000, -684.999023 },
                { -84.000000, -700.000000, -999.999023 },
                { 420.000031, -666.666687, -684.999023 } } } },

    /** Patch 26 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.999901, -666.666687, -345.001953 },
                { 420.000031, -666.666687, -684.999023 },
                { -390.000092, -666.666687, -660.001953 } } } },

    /** Patch 27 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -390.000092, -700.000000, -660.001953 },
                { -84.000000, -700.000000, -999.999023 },
                { 113.999901, -700.000000, -345.001953 } } } },

    /** Patch 28 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -84.000000, -700.000000, -999.999023 },
                { -390.000092, -700.000000, -660.001953 },
                { -84.000000, -666.666687, -999.999023 } } } },

    /** Patch 29 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -390.000092, -700.000000, -660.001953 },
                { 113.999901, -700.000000, -345.001953 },
                { -390.000092, -666.666687, -660.001953 } } } },

    /** Patch 30 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -138.000107, -500.000214, -940.001953 },
                { 341.999695, -500.000214, -640.002930 },
                { -138.000107, -350.000000, -940.001953 } } } },

    /** Patch 31 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 341.999695, -500.000214, -640.002930 },
                { 378.000000, -500.000214, -680.000977 },
                { 341.999695, -350.000000, -640.002930 } } } },

    /** Patch 32 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 378.000000, -500.000214, -680.000977 },
                { -101.999802, -500.000214, -980.000122 },
                { 378.000000, -350.000000, -680.000977 } } } },

    /** Patch 33 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -101.999802, -500.000214, -980.000122 },
                { -138.000107, -500.000214, -940.001953 },
                { -101.999802, -350.000000, -980.000122 } } } },

    /** Patch 34 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -138.000107, -666.666687, -940.001953 },
                { 341.999695, -666.666687, -640.002930 },
                { -138.000107, -533.332825, -940.001953 } } } },

    /** Patch 35 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 341.999695, -666.666687, -640.002930 },
                { 378.000000, -666.666687, -680.000977 },
                { 341.999695, -533.332825, -640.002930 } } } },

    /** Patch 36 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 378.000000, -666.666687, -680.000977 },
                { -101.999802, -666.666687, -980.000122 },
                { 378.000000, -533.332825, -680.000977 } } } },

    /** Patch 37 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -101.999802, -666.666687, -980.000122 },
                { -138.000107, -666.666687, -940.001953 },
                { -101.999802, -533.332825, -980.000122 } } } },

    /** Patch 38 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -138.000107, -800.002014, -940.001953 },
                { 341.999695, -800.002014, -640.002930 },
                { -138.000107, -700.000000, -940.001953 } } } },

    /** Patch 39 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 341.999695, -800.002014, -640.002930 },
                { 378.000000, -800.002014, -680.000977 },
                { 341.999695, -700.000000, -640.002930 } } } },

    /** Patch 40 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 378.000000, -800.002014, -680.000977 },
                { -101.999802, -800.002014, -980.000122 },
                { 378.000000, -700.000000, -680.000977 } } } },

    /** Patch 41 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -101.999802, -800.002014, -980.000122 },
                { -138.000107, -800.002014, -940.001953 },
                { -101.999802, -700.000000, -980.000122 } } } },

    /** Patch 42 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 108.000198, -500.000214, -380.002075 },
                { 120.000298, -500.000214, -393.337036 },
                { 108.000198, -350.000000, -380.002075 } } } },

    /** Patch 43 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 104.000397, -500.000214, -403.333008 },
                { 91.999603, -500.000214, -389.998047 },
                { 104.000397, -350.000000, -403.333008 } } } },

    /** Patch 44 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 120.000298, -500.000214, -393.337036 },
                { 104.000397, -500.000214, -403.333008 },
                { 120.000298, -350.000000, -393.337036 } } } },

    /** Patch 45 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 91.999603, -500.000214, -389.998047 },
                { 108.000198, -500.000214, -380.002075 },
                { 91.999603, -350.000000, -389.998047 } } } },

    /** Patch 46 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 108.000198, -666.666687, -380.002075 },
                { 120.000298, -666.666687, -393.337036 },
                { 108.000198, -533.332825, -380.002075 } } } },

    /** Patch 47 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 104.000397, -666.666687, -403.333008 },
                { 91.999603, -666.666687, -389.998047 },
                { 104.000397, -533.332825, -403.333008 } } } },

    /** Patch 48 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 120.000298, -666.666687, -393.337036 },
                { 104.000397, -666.666687, -403.333008 },
                { 120.000298, -533.332825, -393.337036 } } } },

    /** Patch 49 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 91.999603, -666.666687, -389.998047 },
                { 108.000198, -666.666687, -380.002075 },
                { 91.999603, -533.332825, -389.998047 } } } },

    /** Patch 50 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -308.000000, -500.000214, -640.002930 },
                { -295.999207, -500.000214, -653.331055 },
                { -308.000000, -350.000000, -640.002930 } } } },

    /** Patch 51 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -295.999207, -500.000214, -653.331055 },
                { -311.999786, -500.000214, -663.333984 },
                { -295.999207, -350.000000, -653.331055 } } } },

    /** Patch 52 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -311.999786, -500.000214, -663.333984 },
                { -323.999908, -500.000214, -649.999023 },
                { -311.999786, -350.000000, -663.333984 } } } },

    /** Patch 53 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -323.999908, -500.000214, -649.999023 },
                { -308.000000, -500.000214, -640.002930 },
                { -323.999908, -350.000000, -649.999023 } } } },

    /** Patch 54 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -308.000000, -666.666687, -640.002930 },
                { -295.999207, -666.666687, -653.331055 },
                { -308.000000, -533.332825, -640.002930 } } } },

    /** Patch 55 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -295.999207, -666.666687, -653.331055 },
                { -311.999786, -666.666687, -663.333984 },
                { -295.999207, -533.332825, -653.331055 } } } },

    /** Patch 56 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -311.999786, -666.666687, -663.333984 },
                { -323.999908, -666.666687, -649.999023 },
                { -311.999786, -533.332825, -663.333984 } } } },

    /** Patch 57 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -323.999908, -666.666687, -649.999023 },
                { -308.000000, -666.666687, -640.002930 },
                { -323.999908, -533.332825, -649.999023 } } } },

    /** Patch 58 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 433.708832, -566.666809, -144.088013 },
                { 298.470917, -566.666809, 97.593323 },
                { 424.914001, -534.328918, -147.503967 } } } },

    /** Patch 59 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 298.470917, -566.666809, 97.593323 },
                { 509.488007, -518.146973, 179.592041 },
                { 289.676117, -534.328918, 94.175232 } } } },

    /** Patch 60 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 644.725891, -518.146973, -62.090027 },
                { 433.708832, -566.666809, -144.088013 },
                { 635.931091, -485.809113, -65.505981 } } } },

    /** Patch 61 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 433.708832, -566.666809, -144.088013 },
                { 644.725891, -518.146973, -62.090027 },
                { 298.470917, -566.666809, 97.593323 } } } },

    /** Patch 62 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 509.488007, -518.146973, 179.592041 },
                { 644.725891, -518.146973, -62.090027 },
                { 500.693207, -485.809113, 176.174622 } } } },

    /** Patch 63 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 289.676117, -534.328918, 94.175232 },
                { 500.693207, -485.809113, 176.174622 },
                { 424.914001, -534.328918, -147.503967 } } } },

    /** Patch 64 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 188.395203, -633.333435, -257.802979 },
                { 356.457520, -695.767822, -192.500000 },
                { 36.252300, -633.333435, 14.087463 } } } },

    /** Patch 65 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 36.252300, -633.333435, 14.087463 },
                { 204.315292, -695.767822, 79.394714 },
                { 49.833000, -602.427002, 19.364807 } } } },

    /** Patch 66 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 356.457520, -695.767822, -192.500000 },
                { 188.395203, -633.333435, -257.802979 },
                { 370.038208, -664.861389, -187.221985 } } } },

    /** Patch 67 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 204.315292, -695.767822, 79.394714 },
                { 356.457520, -695.767822, -192.500000 },
                { 217.895294, -664.861389, 84.671997 } } } },

    /** Patch 68 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 188.395203, -633.333435, -257.802979 },
                { 36.252300, -633.333435, 14.087463 },
                { 201.975204, -602.427002, -252.524963 } } } },

    /** Patch 69 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 49.833000, -602.427002, 19.364807 },
                { 217.895294, -664.861389, 84.671997 },
                { 201.975204, -602.427002, -252.524963 } } } },

    /** Patch 70 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 650.722107, -800.002014, 10.894836 },
                { 580.434387, -800.002014, 136.506287 },
                { 533.348206, -541.608887, -85.043030 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 416.794708, -541.608887, 123.246887 },
                { 533.348206, -541.608887, -85.043030 },
                { 580.434387, -800.002014, 136.506287 } } } },

    /** Patch 71 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 650.722107, -800.002014, 10.894836 },
                { 533.348206, -541.608887, -85.043030 },
                { 689.917908, -800.002014, 29.029724 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 568.779419, -533.325073, -69.986023 },
                { 689.917908, -800.002014, 29.029724 },
                { 533.348206, -541.608887, -85.043030 } } } },

    /** Patch 72 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 416.794708, -541.608887, 123.246887 },
                { 580.434387, -800.002014, 136.506287 },
                { 453.411713, -533.325073, 136.186401 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 622.298584, -800.002014, 149.870728 },
                { 453.411713, -533.325073, 136.186401 },
                { 580.434387, -800.002014, 136.506287 } } } },

    /** Patch 73 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 622.298584, -800.002014, 149.870728 },
                { 689.917908, -800.002014, 29.029724 },
                { 453.411713, -533.325073, 136.186401 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 568.779419, -533.325073, -69.986023 },
                { 453.411713, -533.325073, 136.186401 },
                { 689.917908, -800.002014, 29.029724 } } } },

    /** Patch 74 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 67.053001, -800.002014, -25.025024 },
                { 172.239197, -800.002014, -213.003052 },
                { 147.604797, -670.852722, 34.824341 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 279.033295, -670.852722, -200.052979 },
                { 147.604797, -670.852722, 34.824341 },
                { 172.239197, -800.002014, -213.003052 } } } },

    /** Patch 75 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 279.033295, -670.852722, -200.052979 },
                { 172.239197, -800.002014, -213.003052 },
                { 244.124313, -658.100830, -212.344971 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 126.785400, -800.002014, -226.576050 },
                { 244.124313, -658.100830, -212.344971 },
                { 172.239197, -800.002014, -213.003052 } } } },

    /** Patch 76 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 67.053001, -800.002014, -25.025024 },
                { 147.604797, -670.852722, 34.824341 },
                { 25.356800, -800.002014, -45.317932 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.862701, -658.100830, 20.442810 },
                { 25.356800, -800.002014, -45.317932 },
                { 147.604797, -670.852722, 34.824341 } } } },

    /** Patch 77 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 126.785400, -800.002014, -226.576050 },
                { 25.356800, -800.002014, -45.317932 },
                { 244.124313, -658.100830, -212.344971 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.862701, -658.100830, 20.442810 },
                { 244.124313, -658.100830, -212.344971 },
                { 25.356800, -800.002014, -45.317932 } } } },

    /** Patch 78 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 185.036591, -766.667969, -183.266968 },
                { 102.610901, -766.667969, -35.966003 },
                { 623.555115, -766.667969, 20.008118 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 571.348389, -766.667969, 113.306213 },
                { 623.555115, -766.667969, 20.008118 },
                { 102.610901, -766.667969, -35.966003 } } } },

    /** Patch 79 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 641.077515, -800.002014, 28.130920 },
                { 161.664307, -800.002014, -194.102966 },
                { 623.555115, -766.667969, 20.008118 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 185.036591, -766.667969, -183.266968 },
                { 623.555115, -766.667969, 20.008118 },
                { 161.664307, -800.002014, -194.102966 } } } },

    /** Patch 80 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 77.628601, -800.002014, -43.924988 },
                { 590.078308, -800.002014, 119.270935 },
                { 102.610901, -766.667969, -35.966003 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 571.348389, -766.667969, 113.306213 },
                { 102.610901, -766.667969, -35.966003 },
                { 590.078308, -800.002014, 119.270935 } } } },

    /** Patch 81 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, -66.666603, -999.999023 },
                { -840.000061, -66.666603, -999.999023 },
                { -360.000183, -66.666603, -700.000000 } } } },

    /** Patch 82 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, -233.333084, -999.999023 },
                { -840.000061, -233.333084, -999.999023 },
                { -479.999817, -233.333084, -599.997925 } } } },

    /** Patch 83 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, -266.666412, -599.997925 },
                { -840.000061, -266.666412, -599.997925 },
                { -479.999817, -266.666412, -999.999023 } } } },

    /** Patch 84 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, -266.666412, -999.999023 },
                { -840.000061, -266.666412, -999.999023 },
                { -479.999817, -233.333084, -999.999023 } } } },

    /** Patch 85 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -266.666412, -999.999023 },
                { -840.000061, -266.666412, -599.997925 },
                { -840.000061, -233.333084, -999.999023 } } } },

    /** Patch 86 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -266.666412, -599.997925 },
                { -479.999817, -266.666412, -599.997925 },
                { -840.000061, -233.333084, -599.997925 } } } },

    /** Patch 87 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, -266.666412, -599.997925 },
                { -479.999817, -266.666412, -999.999023 },
                { -479.999817, -233.333084, -599.997925 } } } },

    /** Patch 88 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -800.002014, -999.999023 },
                { -840.000061, -800.002014, -999.999023 },
                { -800.002014, -266.666412, -999.999023 } } } },

    /** Patch 89 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -800.002014, -999.999023 },
                { -840.000061, -800.002014, -966.665039 },
                { -840.000061, -266.666412, -999.999023 } } } },

    /** Patch 90 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -800.002014, -966.665039 },
                { -800.002014, -800.002014, -966.665039 },
                { -840.000061, -266.666412, -966.665039 } } } },

    /** Patch 91 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -800.002014, -966.665039 },
                { -800.002014, -800.002014, -999.999023 },
                { -800.002014, -266.666412, -966.665039 } } } },

    /** Patch 92 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, -99.999901, -700.000000 },
                { -840.000061, -99.999901, -700.000000 },
                { -360.000183, -99.999901, -999.999023 } } } },

    /** Patch 93 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, -99.999901, -999.999023 },
                { -840.000061, -99.999901, -999.999023 },
                { -360.000183, -66.666603, -999.999023 } } } },

    /** Patch 94 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -99.999901, -999.999023 },
                { -840.000061, -99.999901, -700.000000 },
                { -840.000061, -66.666603, -999.999023 } } } },

    /** Patch 95 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -99.999901, -700.000000 },
                { -360.000183, -99.999901, -700.000000 },
                { -840.000061, -66.666603, -700.000000 } } } },

    /** Patch 96 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, -99.999901, -700.000000 },
                { -360.000183, -99.999901, -999.999023 },
                { -360.000183, -66.666603, -700.000000 } } } },

    /** Patch 97 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -233.333084, -999.999023 },
                { -840.000061, -233.333084, -999.999023 },
                { -800.002014, -99.999901, -999.999023 } } } },

    /** Patch 98 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -233.333084, -999.999023 },
                { -840.000061, -233.333084, -966.665039 },
                { -840.000061, -99.999901, -999.999023 } } } },

    /** Patch 99 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -233.333084, -966.665039 },
                { -800.002014, -233.333084, -966.665039 },
                { -840.000061, -99.999901, -966.665039 } } } },

    /** Patch 100 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -233.333084, -966.665039 },
                { -800.002014, -233.333084, -999.999023 },
                { -800.002014, -99.999901, -966.665039 } } } },

    /** Patch 101 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, 400.000305, -999.999023 },
                { -840.000061, 400.000305, -999.999023 },
                { -800.002014, 400.000305, -966.665039 } } } },

    /** Patch 102 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, 99.999901, -999.999023 },
                { -840.000061, 99.999901, -999.999023 },
                { -479.999817, 99.999901, -599.997925 } } } },

    /** Patch 103 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, 66.666603, -599.997925 },
                { -840.000061, 66.666603, -599.997925 },
                { -479.999817, 66.666603, -999.999023 } } } },

    /** Patch 104 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, 66.666603, -999.999023 },
                { -840.000061, 66.666603, -999.999023 },
                { -479.999817, 99.999901, -999.999023 } } } },

    /** Patch 105 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 66.666603, -999.999023 },
                { -840.000061, 66.666603, -599.997925 },
                { -840.000061, 99.999901, -999.999023 } } } },

    /** Patch 106 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 66.666603, -599.997925 },
                { -479.999817, 66.666603, -599.997925 },
                { -840.000061, 99.999901, -599.997925 } } } },

    /** Patch 107 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, 66.666603, -599.997925 },
                { -479.999817, 66.666603, -999.999023 },
                { -479.999817, 99.999901, -599.997925 } } } },

    /** Patch 108 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -66.666603, -999.999023 },
                { -840.000061, -66.666603, -999.999023 },
                { -800.002014, 66.666603, -999.999023 } } } },

    /** Patch 109 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -66.666603, -999.999023 },
                { -840.000061, -66.666603, -966.665039 },
                { -840.000061, 66.666603, -999.999023 } } } },

    /** Patch 110 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -66.666603, -966.665039 },
                { -800.002014, -66.666603, -966.665039 },
                { -840.000061, 66.666603, -966.665039 } } } },

    /** Patch 111 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -66.666603, -966.665039 },
                { -800.002014, -66.666603, -999.999023 },
                { -800.002014, 66.666603, -966.665039 } } } },

    /** Patch 112 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, 233.333084, -700.000000 },
                { -360.000183, 233.333084, -999.999023 },
                { -360.000183, 266.666412, -700.000000 } } } },

    /** Patch 113 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, 266.666412, -999.999023 },
                { -840.000061, 266.666412, -999.999023 },
                { -360.000183, 266.666412, -700.000000 } } } },

    /** Patch 114 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, 233.333084, -700.000000 },
                { -840.000061, 233.333084, -700.000000 },
                { -360.000183, 233.333084, -999.999023 } } } },

    /** Patch 115 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, 233.333084, -999.999023 },
                { -840.000061, 233.333084, -999.999023 },
                { -360.000183, 266.666412, -999.999023 } } } },

    /** Patch 116 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 233.333084, -999.999023 },
                { -840.000061, 233.333084, -700.000000 },
                { -840.000061, 266.666412, -999.999023 } } } },

    /** Patch 117 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 233.333084, -700.000000 },
                { -360.000183, 233.333084, -700.000000 },
                { -840.000061, 266.666412, -700.000000 } } } },

    /** Patch 118 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, 99.999901, -999.999023 },
                { -840.000061, 99.999901, -999.999023 },
                { -800.002014, 233.333084, -999.999023 } } } },

    /** Patch 119 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 99.999901, -999.999023 },
                { -840.000061, 99.999901, -966.665039 },
                { -840.000061, 233.333084, -999.999023 } } } },

    /** Patch 120 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 99.999901, -966.665039 },
                { -800.002014, 99.999901, -966.665039 },
                { -840.000061, 233.333084, -966.665039 } } } },

    /** Patch 121 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, 99.999901, -966.665039 },
                { -800.002014, 99.999901, -999.999023 },
                { -800.002014, 233.333084, -966.665039 } } } },

    /** Patch 122 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, 266.666412, -999.999023 },
                { -840.000061, 266.666412, -999.999023 },
                { -800.002014, 400.000305, -999.999023 } } } },

    /** Patch 123 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 266.666412, -999.999023 },
                { -840.000061, 266.666412, -966.665039 },
                { -840.000061, 400.000305, -999.999023 } } } },

    /** Patch 124 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 266.666412, -966.665039 },
                { -800.002014, 266.666412, -966.665039 },
                { -840.000061, 400.000305, -966.665039 } } } },

    /** Patch 125 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, 266.666412, -966.665039 },
                { -800.002014, 266.666412, -999.999023 },
                { -800.002014, 400.000305, -966.665039 } } } },

    /** Patch 126 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 392.043396, 243.630798, -351.567993 },
                { 242.694885, 183.257202, -315.875000 },
                { 510.173309, 243.630798, -8.260010 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 398.162109, 198.350601, 18.507324 },
                { 510.173309, 243.630798, -8.260010 },
                { 242.694885, 183.257202, -315.875000 } } } },

    /** Patch 127 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 396.395996, 235.538788, -352.604004 },
                { 512.350281, 239.584793, -8.778015 },
                { 247.047501, 175.165207, -316.917969 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 400.338379, 194.304596, 17.987915 },
                { 247.047501, 175.165207, -316.917969 },
                { 512.350281, 239.584793, -8.778015 } } } },

    /** Patch 128 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 356.604492, 243.630798, -454.558960 },
                { 238.473892, 243.630798, -797.867065 },
                { 207.255997, 183.257202, -418.873047 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 126.462692, 198.350601, -771.098877 },
                { 207.255997, 183.257202, -418.873047 },
                { 238.473892, 243.630798, -797.867065 } } } },

    /** Patch 129 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 360.957123, 235.538788, -455.595093 },
                { 211.608612, 175.165207, -419.908936 },
                { 240.650208, 239.584793, -798.384888 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 128.639008, 194.304596, -771.616943 },
                { 240.650208, 239.584793, -798.384888 },
                { 211.608612, 175.165207, -419.908936 } } } },

    /** Patch 130 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 312.337189, 53.784500, -332.520996 },
                { 461.685730, 114.158798, -368.207031 },
                { 467.804382, 68.877899, 1.866211 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 579.816284, 114.158798, -24.899048 },
                { 467.804382, 68.877899, 1.866211 },
                { 461.685730, 114.158798, -368.207031 } } } },

    /** Patch 131 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 308.116211, 114.158798, -814.505981 },
                { 426.246765, 114.158798, -471.197998 },
                { 196.104996, 68.877899, -787.744995 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 276.898285, 53.784500, -435.511963 },
                { 196.104996, 68.877899, -787.744995 },
                { 426.246765, 114.158798, -471.197998 } } } },

    /** Patch 132 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 765.387024, 266.184113, -515.088013 },
                { 777.203064, 266.184113, -480.753052 },
                { 426.246765, 114.158798, -471.197998 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 461.685730, 114.158798, -368.207031 },
                { 426.246765, 114.158798, -471.197998 },
                { 777.203064, 266.184113, -480.753052 } } } },

    /** Patch 133 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 777.203064, 266.184113, -480.753052 },
                { 759.794006, 298.552094, -476.594971 },
                { 461.685730, 114.158798, -368.207031 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 426.864197, 178.894806, -359.884033 },
                { 461.685730, 114.158798, -368.207031 },
                { 759.794006, 298.552094, -476.594971 } } } },

    /** Patch 134 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 759.794006, 298.552094, -476.594971 },
                { 747.977966, 298.552094, -510.922974 },
                { 426.864197, 178.894806, -359.884033 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 391.425293, 178.894806, -462.881958 },
                { 426.864197, 178.894806, -359.884033 },
                { 747.977966, 298.552094, -510.922974 } } } },

    /** Patch 135 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 747.977966, 298.552094, -510.922974 },
                { 765.387024, 266.184113, -515.088013 },
                { 391.425293, 178.894806, -462.881958 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 426.246765, 114.158798, -471.197998 },
                { 391.425293, 178.894806, -462.881958 },
                { 765.387024, 266.184113, -515.088013 } } } },

    /** Patch 136 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 765.387024, 266.184113, -515.088013 },
                { 747.977966, 298.552094, -510.922974 },
                { 777.203064, 266.184113, -480.753052 } } } },

    /** Patch 137 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 426.246765, 114.158798, -471.197998 },
                { 276.898285, 53.784500, -435.511963 },
                { 391.425293, 178.894806, -462.881958 } } } },

    /** Patch 138 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 312.337189, 53.784500, -332.520996 },
                { 461.685730, 114.158798, -368.207031 },
                { 277.516418, 118.520500, -324.197998 } } } },

    /** Patch 139 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 391.425293, 178.894806, -462.881958 },
                { 242.076797, 118.520500, -427.188965 },
                { 426.864197, 178.894806, -359.884033 } } } },

    /** Patch 140 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 461.685730, 114.158798, -368.207031 },
                { 312.337189, 53.784500, -332.520996 },
                { 426.246765, 114.158798, -471.197998 } } } },

    /** Patch 141 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 242.669006, 54.875099, -390.179932 },
                { 254.482208, 54.875099, -355.844971 },
                { 225.257904, 87.243103, -386.021973 } } } },

    /** Patch 142 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 242.076797, 118.520500, -427.188965 },
                { 225.257904, 87.243103, -386.021973 },
                { 277.516418, 118.520500, -324.197998 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 237.071091, 87.243103, -351.687012 },
                { 277.516418, 118.520500, -324.197998 },
                { 225.257904, 87.243103, -386.021973 } } } },

    /** Patch 143 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 242.669006, 54.875099, -390.179932 },
                { 276.898285, 53.784500, -435.511963 },
                { 254.482208, 54.875099, -355.844971 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 312.337189, 53.784500, -332.520996 },
                { 254.482208, 54.875099, -355.844971 },
                { 276.898285, 53.784500, -435.511963 } } } },

    /** Patch 144 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 242.076797, 118.520500, -427.188965 },
                { 276.898285, 53.784500, -435.511963 },
                { 225.257904, 87.243103, -386.021973 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 242.669006, 54.875099, -390.179932 },
                { 225.257904, 87.243103, -386.021973 },
                { 276.898285, 53.784500, -435.511963 } } } },

    /** Patch 145 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 312.337189, 53.784500, -332.520996 },
                { 277.516418, 118.520500, -324.197998 },
                { 254.482208, 54.875099, -355.844971 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 237.071091, 87.243103, -351.687012 },
                { 254.482208, 54.875099, -355.844971 },
                { 277.516418, 118.520500, -324.197998 } } } },

    /** Patch 146 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 356.604492, 243.630798, -454.558960 },
                { 207.255997, 183.257202, -418.873047 },
                { 392.043396, 243.630798, -351.567993 } } } },

    /** Patch 147 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 752.408997, 298.552094, -498.050049 },
                { 675.556702, 272.411285, -479.688965 },
                { 717.583984, 363.288818, -489.727051 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 680.249512, 348.194702, -480.808960 },
                { 717.583984, 363.288818, -489.727051 },
                { 675.556702, 272.411285, -479.688965 } } } },

    /** Patch 148 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 678.510010, 272.411285, -471.106934 },
                { 755.362976, 298.552094, -489.468018 },
                { 683.202820, 348.194702, -472.227051 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 720.538025, 363.288818, -481.145020 },
                { 683.202820, 348.194702, -472.227051 },
                { 755.362976, 298.552094, -489.468018 } } } },

    /** Patch 149 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 758.855957, 278.322113, -513.526978 },
                { 681.231567, 248.135315, -504.265991 },
                { 723.421997, 278.322113, -616.518066 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 686.083313, 263.228699, -607.593018 },
                { 723.421997, 278.322113, -616.518066 },
                { 681.231567, 248.135315, -504.265991 } } } },

    /** Patch 150 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 676.879028, 256.227295, -503.223022 },
                { 754.509033, 286.414093, -512.484009 },
                { 681.730652, 271.320679, -606.557007 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 719.068054, 286.414093, -615.474976 },
                { 681.730652, 271.320679, -606.557007 },
                { 754.509033, 286.414093, -512.484009 } } } },

    /** Patch 151 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 766.317993, 286.414093, -478.156006 },
                { 694.598816, 256.227295, -451.730957 },
                { 801.759033, 286.414093, -375.164917 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 764.421021, 271.320679, -366.239990 },
                { 801.759033, 286.414093, -375.164917 },
                { 694.598816, 256.227295, -451.730957 } } } },

    /** Patch 152 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 698.951416, 248.135315, -452.767090 },
                { 770.671997, 278.322113, -479.192017 },
                { 768.775024, 263.228699, -367.283081 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 806.112976, 278.322113, -376.201050 },
                { 768.775024, 263.228699, -367.283081 },
                { 770.671997, 278.322113, -479.192017 } } } },

    /** Patch 153 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 577.639282, 118.204796, -24.380981 },
                { 457.333099, 122.250793, -367.164062 },
                { 465.628113, 72.923897, 2.386292 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 307.984589, 61.876499, -331.477905 },
                { 465.628113, 72.923897, 2.386292 },
                { 457.333099, 122.250793, -367.164062 } } } },

    /** Patch 154 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 272.545715, 61.876499, -434.468994 },
                { 421.894196, 122.250793, -470.161987 },
                { 193.928696, 72.923897, -787.219971 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 305.939880, 118.204796, -813.987915 },
                { 193.928696, 72.923897, -787.219971 },
                { 421.894196, 122.250793, -470.161987 } } } },

    /** Patch 155 **/
    { MODEL_RECTANGLE,
        { { 1.000000, 1.000000, 1.000000 }, { 300.000000, 300.000000, 300.000000 },
            { { -229.925507, 290.945190, -923.173950 },
                { -297.808014, 290.945190, -866.606934 },
                { -258.613617, 218.439896, -947.078979 } } } },

    /** Patch 156 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -329.024506, 295.358704, -920.905884 },
                { -343.368195, 259.105713, -932.854980 },
                { -297.808014, 290.945190, -866.606934 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -326.496094, 218.439896, -890.512085 },
                { -297.808014, 290.945190, -866.606934 },
                { -343.368195, 259.105713, -932.854980 } } } },

    /** Patch 157 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -343.368195, 259.105713, -932.854980 },
                { -309.427307, 259.105713, -961.141968 },
                { -326.496094, 218.439896, -890.512085 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -258.613617, 218.439896, -947.078979 },
                { -326.496094, 218.439896, -890.512085 },
                { -309.427307, 259.105713, -961.141968 } } } },

    /** Patch 158 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -309.427307, 259.105713, -961.141968 },
                { -295.082886, 295.358704, -949.185913 },
                { -258.613617, 218.439896, -947.078979 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -229.925507, 290.945190, -923.173950 },
                { -258.613617, 218.439896, -947.078979 },
                { -295.082886, 295.358704, -949.185913 } } } },

    /** Patch 159 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -295.082886, 295.358704, -949.185913 },
                { -329.024506, 295.358704, -920.905884 },
                { -229.925507, 290.945190, -923.173950 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -297.808014, 290.945190, -866.606934 },
                { -229.925507, 290.945190, -923.173950 },
                { -329.024506, 295.358704, -920.905884 } } } },

    /** Patch 160 **/
    { MODEL_RECTANGLE,
        { { 1.000000, 1.000000, 1.000000 }, { 300.000000, 300.000000, 300.000000 },
            { { -651.277222, 370.474304, -517.432983 },
                { -691.848511, 370.474304, -444.927002 },
                { -694.779419, 301.192505, -534.338013 } } } },

    /** Patch 161 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -742.811951, 379.820679, -486.801025 },
                { -764.567993, 345.179810, -495.250000 },
                { -691.848511, 370.474304, -444.927002 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -735.350037, 301.192505, -461.832031 },
                { -691.848511, 370.474304, -444.927002 },
                { -764.567993, 345.179810, -495.250000 } } } },

    /** Patch 162 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -764.567993, 345.179810, -495.250000 },
                { -744.281982, 345.179810, -531.502930 },
                { -735.350037, 301.192505, -461.832031 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -694.779419, 301.192505, -534.338013 },
                { -735.350037, 301.192505, -461.832031 },
                { -744.281982, 345.179810, -531.502930 } } } },

    /** Patch 163 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -744.281982, 345.179810, -531.502930 },
                { -722.525940, 379.820679, -523.046997 },
                { -694.779419, 301.192505, -534.338013 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -651.277222, 370.474304, -517.432983 },
                { -694.779419, 301.192505, -534.338013 },
                { -722.525940, 379.820679, -523.046997 } } } },

    /** Patch 164 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -722.525940, 379.820679, -523.046997 },
                { -742.811951, 379.820679, -486.801025 },
                { -651.277222, 370.474304, -517.432983 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -691.848511, 370.474304, -444.927002 },
                { -651.277222, 370.474304, -517.432983 },
                { -742.811951, 379.820679, -486.801025 } } } },

    /** Patch 165 **/
    { MODEL_RECTANGLE,
        { { 0.186700, 0.186700, 0.186700 }, { 0.000000, 0.000000, 0.000000 },
            { { -420.000031, 654.000183, -299.999023 },
                { 420.000031, 654.000183, -299.999023 },
                { -420.000031, 600.000061, -299.999023 } } } },

    /** Patch 166 **/
    { MODEL_RECTANGLE,
        { { 0.186700, 0.186700, 0.186700 }, { 0.000000, 0.000000, 0.000000 },
            { { 420.000031, 654.000183, -299.999023 },
                { 420.000031, 654.000183, 0.000000 },
                { 420.000031, 600.000061, -299.999023 } } } },

    /** Patch 167 **/
    { MODEL_RECTANGLE,
        { { 0.186700, 0.186700, 0.186700 }, { 0.000000, 0.000000, 0.000000 },
            { { 420.000031, 654.000183, 0.000000 },
                { -420.000031, 654.000183, 0.000000 },
                { 420.000031, 600.000061, 0.000000 } } } },

    /** Patch 168 **/
    { MODEL_RECTANGLE,
        { { 0.186700, 0.186700, 0.186700 }, { 0.000000, 0.000000, 0.000000 },
            { { -420.000031, 654.000183, 0.000000 },
                { -420.000031, 654.000183, -299.999023 },
                { -420.000031, 600.000061, 0.000000 } } } },

    /** Patch 169 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 120.000000, 120.000000, 120.000000 },
            { { -264.000092, 628.000122, -150.002991 },
                { -264.000092, 628.000122, -190.001038 },
                { -215.999710, 628.000122, -150.002991 } } } },

    /** Patch 170 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 60.000000, 60.000000, 60.000000 },
            { { -264.000092, 631.333496, -190.001038 },
                { -264.000092, 631.333496, -150.002991 },
                { -215.999710, 631.333496, -190.001038 } } } },

    /** Patch 171 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 120.000000, 120.000000, 120.000000 },
            { { -24.000200, 628.000122, -150.002991 },
                { -24.000200, 628.000122, -190.001038 },
                { 24.000200, 628.000122, -150.002991 } } } },

    /** Patch 172 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 60.000000, 60.000000, 60.000000 },
            { { -24.000200, 631.333496, -190.001038 },
                { -24.000200, 631.333496, -150.002991 },
                { 24.000200, 631.333496, -190.001038 } } } },

    /** Patch 173 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 120.000000, 120.000000, 120.000000 },
            { { 215.999710, 628.000122, -150.002991 },
                { 215.999710, 628.000122, -190.001038 },
                { 264.000092, 628.000122, -150.002991 } } } },

    /** Patch 174 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 60.000000, 60.000000, 60.000000 },
            { { 215.999710, 631.333496, -190.001038 },
                { 215.999710, 631.333496, -150.002991 },
                { 264.000092, 631.333496, -190.001038 } } } },




    { MODEL_NULL } } ;




ModelDataBase largeroom_model[] =
{

    /** Patch 0 **/
    { MODEL_RECTANGLE,
        { { 0.615686, 0.737255, 0.870588 }, { 0.000000, 0.000000, 0.000000 },
            { { 847.000000, -800.002014, 0.000000 },
                { 840.000061, -800.002014, 0.000000 },
                { 847.000000, -793.001953, 0.000000 } } } },

    /** Patch 1 **/
    { MODEL_RECTANGLE,
        { { 0.615686, 0.737255, 0.870588 }, { 0.000000, 0.000000, 0.000000 },
            { { -847.000000, -800.002014, -1701.000000 },
                { 847.000000, -800.002014, -1701.000000 },
                { -847.000000, 800.002014, -1701.000000 } } } },

    /** Patch 2 **/
    { MODEL_RECTANGLE,
        { { 0.615686, 0.737255, 0.870588 }, { 0.000000, 0.000000, 0.000000 },
            { { 847.000000, -800.002014, -1701.000000 },
                { 847.000000, -800.002014, 0.000000 },
                { 847.000000, 800.002014, -1701.000000 } } } },

    /** Patch 3 **/
    { MODEL_RECTANGLE,
        { { 0.615686, 0.737255, 0.870588 }, { 0.000000, 0.000000, 0.000000 },
            { { -847.000000, -800.002014, 0.000000 },
                { -847.000000, -800.002014, -1701.000000 },
                { -847.000000, 800.002014, 0.000000 } } } },

    /** Patch 4 **/
    { MODEL_RECTANGLE,
        { { 0.603921, 0.603921, 0.603921 }, { 0.000000, 0.000000, 0.000000 },
            { { 847.000000, 800.002014, 0.000000 },
                { -847.000000, 800.002014, 0.000000 },
                { 847.000000, 800.002014, -1701.000000 } } } },

    /** Patch 5 **/
    { MODEL_RECTANGLE,
        { { 0.501961, 0.501961, 0.501961 }, { 0.000000, 0.000000, 0.000000 },
            { { 847.000000, -800.002014, -1701.000000 },
                { -847.000000, -800.002014, -1701.000000 },
                { 847.000000, -800.002014, 0.000000 } } } },

    /** Patch 6 **/
    { MODEL_RECTANGLE,
        { { 0.576470, 0.521569, 0.521568 }, { 0.000000, 0.000000, 0.000000 },
            { { -269.149994, -216.666794, -1701.000000 },
                { 165.895096, -216.666794, -1701.000000 },
                { -269.149994, 281.666687, -1701.000000 } } } },

    /** Patch 7 **/
    { MODEL_RECTANGLE,
        { { 0.098034, 0.086275, 0.074510 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -159.999695, -414.019897 },
                { -840.000061, -159.999695, -1104.214966 },
                { -840.000061, 298.332977, -414.019897 } } } },

    /** Patch 8 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -84.000000, -350.000000, -1699.999023 },
                { -840.000061, -350.000000, -859.998962 },
                { -84.000000, -299.999695, -1699.999023 } } } },

    /** Patch 9 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -350.000000, -859.998962 },
                { -84.000000, -350.000000, -1699.999023 },
                { -336.000000, -350.000000, -544.999695 } } } },

    /** Patch 10 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -336.000000, -299.999695, -544.999695 },
                { 420.000031, -299.999695, -1384.999023 },
                { -840.000061, -299.999695, -859.998962 } } } },

    /** Patch 11 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -336.000000, -350.000000, -544.999695 },
                { 420.000031, -350.000000, -1384.999023 },
                { -336.000000, -299.999695, -544.999695 } } } },

    /** Patch 12 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 420.000031, -350.000000, -1384.999023 },
                { -84.000000, -350.000000, -1699.999023 },
                { 420.000031, -299.999695, -1384.999023 } } } },

    /** Patch 13 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -350.000000, -859.998962 },
                { -336.000000, -350.000000, -544.999695 },
                { -840.000061, -299.999695, -859.998962 } } } },

    /** Patch 14 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -306.000092, -800.002014, -619.999817 },
                { -786.001953, -800.002014, -920.003052 },
                { -306.000092, -350.000000, -619.999817 } } } },

    /** Patch 15 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -341.999695, -800.002014, -579.999695 },
                { -306.000092, -800.002014, -619.999817 },
                { -341.999695, -350.000000, -579.999695 } } } },

    /** Patch 16 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -786.001953, -800.002014, -920.003052 },
                { -822.002930, -800.002014, -879.998047 },
                { -786.001953, -350.000000, -920.003052 } } } },

    /** Patch 17 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -822.002930, -800.002014, -879.998047 },
                { -341.999695, -800.002014, -579.999695 },
                { -822.002930, -350.000000, -879.998047 } } } },

    /** Patch 18 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.999901, -533.332825, -1045.001953 },
                { 420.000031, -533.332825, -1384.999023 },
                { 113.999901, -500.000214, -1045.001953 } } } },

    /** Patch 19 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 420.000031, -533.332825, -1384.999023 },
                { -84.000000, -533.332825, -1699.999023 },
                { 420.000031, -500.000214, -1384.999023 } } } },

    /** Patch 20 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.999901, -500.000214, -1045.001953 },
                { 420.000031, -500.000214, -1384.999023 },
                { -390.000092, -500.000214, -1360.001953 } } } },

    /** Patch 21 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -390.000092, -533.332825, -1360.001953 },
                { -84.000000, -533.332825, -1699.999023 },
                { 113.999901, -533.332825, -1045.001953 } } } },

    /** Patch 22 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -84.000000, -533.332825, -1699.999023 },
                { -390.000092, -533.332825, -1360.001953 },
                { -84.000000, -500.000214, -1699.999023 } } } },

    /** Patch 23 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -390.000092, -533.332825, -1360.001953 },
                { 113.999901, -533.332825, -1045.001953 },
                { -390.000092, -500.000214, -1360.001953 } } } },

    /** Patch 24 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.999901, -700.000000, -1045.001953 },
                { 420.000031, -700.000000, -1384.999023 },
                { 113.999901, -666.666687, -1045.001953 } } } },

    /** Patch 25 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 420.000031, -700.000000, -1384.999023 },
                { -84.000000, -700.000000, -1699.999023 },
                { 420.000031, -666.666687, -1384.999023 } } } },

    /** Patch 26 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.999901, -666.666687, -1045.001953 },
                { 420.000031, -666.666687, -1384.999023 },
                { -390.000092, -666.666687, -1360.001953 } } } },

    /** Patch 27 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -390.000092, -700.000000, -1360.001953 },
                { -84.000000, -700.000000, -1699.999023 },
                { 113.999901, -700.000000, -1045.001953 } } } },

    /** Patch 28 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -84.000000, -700.000000, -1699.999023 },
                { -390.000092, -700.000000, -1360.001953 },
                { -84.000000, -666.666687, -1699.999023 } } } },

    /** Patch 29 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -390.000092, -700.000000, -1360.001953 },
                { 113.999901, -700.000000, -1045.001953 },
                { -390.000092, -666.666687, -1360.001953 } } } },

    /** Patch 30 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -138.000107, -500.000214, -1640.001953 },
                { 341.999695, -500.000214, -1340.002930 },
                { -138.000107, -350.000000, -1640.001953 } } } },

    /** Patch 31 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 341.999695, -500.000214, -1340.002930 },
                { 378.000000, -500.000214, -1380.000977 },
                { 341.999695, -350.000000, -1340.002930 } } } },

    /** Patch 32 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 378.000000, -500.000214, -1380.000977 },
                { -101.999802, -500.000214, -1680.000122 },
                { 378.000000, -350.000000, -1380.000977 } } } },

    /** Patch 33 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -101.999802, -500.000214, -1680.000122 },
                { -138.000107, -500.000214, -1640.001953 },
                { -101.999802, -350.000000, -1680.000122 } } } },

    /** Patch 34 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -138.000107, -666.666687, -1640.001953 },
                { 341.999695, -666.666687, -1340.002930 },
                { -138.000107, -533.332825, -1640.001953 } } } },

    /** Patch 35 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 341.999695, -666.666687, -1340.002930 },
                { 378.000000, -666.666687, -1380.000977 },
                { 341.999695, -533.332825, -1340.002930 } } } },

    /** Patch 36 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 378.000000, -666.666687, -1380.000977 },
                { -101.999802, -666.666687, -1680.000122 },
                { 378.000000, -533.332825, -1380.000977 } } } },

    /** Patch 37 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -101.999802, -666.666687, -1680.000122 },
                { -138.000107, -666.666687, -1640.001953 },
                { -101.999802, -533.332825, -1680.000122 } } } },

    /** Patch 38 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -138.000107, -800.002014, -1640.001953 },
                { 341.999695, -800.002014, -1340.002930 },
                { -138.000107, -700.000000, -1640.001953 } } } },

    /** Patch 39 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 341.999695, -800.002014, -1340.002930 },
                { 378.000000, -800.002014, -1380.000977 },
                { 341.999695, -700.000000, -1340.002930 } } } },

    /** Patch 40 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 378.000000, -800.002014, -1380.000977 },
                { -101.999802, -800.002014, -1680.000122 },
                { 378.000000, -700.000000, -1380.000977 } } } },

    /** Patch 41 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -101.999802, -800.002014, -1680.000122 },
                { -138.000107, -800.002014, -1640.001953 },
                { -101.999802, -700.000000, -1680.000122 } } } },

    /** Patch 42 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 108.000198, -500.000214, -1080.002075 },
                { 120.000298, -500.000214, -1093.337036 },
                { 108.000198, -350.000000, -1080.002075 } } } },

    /** Patch 43 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 104.000397, -500.000214, -1103.333008 },
                { 91.999603, -500.000214, -1089.998047 },
                { 104.000397, -350.000000, -1103.333008 } } } },

    /** Patch 44 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 120.000298, -500.000214, -1093.337036 },
                { 104.000397, -500.000214, -1103.333008 },
                { 120.000298, -350.000000, -1093.337036 } } } },

    /** Patch 45 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 91.999603, -500.000214, -1089.998047 },
                { 108.000198, -500.000214, -1080.002075 },
                { 91.999603, -350.000000, -1089.998047 } } } },

    /** Patch 46 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 108.000198, -666.666687, -1080.002075 },
                { 120.000298, -666.666687, -1093.337036 },
                { 108.000198, -533.332825, -1080.002075 } } } },

    /** Patch 47 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 104.000397, -666.666687, -1103.333008 },
                { 91.999603, -666.666687, -1089.998047 },
                { 104.000397, -533.332825, -1103.333008 } } } },

    /** Patch 48 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 120.000298, -666.666687, -1093.337036 },
                { 104.000397, -666.666687, -1103.333008 },
                { 120.000298, -533.332825, -1093.337036 } } } },

    /** Patch 49 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 91.999603, -666.666687, -1089.998047 },
                { 108.000198, -666.666687, -1080.002075 },
                { 91.999603, -533.332825, -1089.998047 } } } },

    /** Patch 50 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -308.000000, -500.000214, -1340.002930 },
                { -295.999207, -500.000214, -1353.331055 },
                { -308.000000, -350.000000, -1340.002930 } } } },

    /** Patch 51 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -295.999207, -500.000214, -1353.331055 },
                { -311.999786, -500.000214, -1363.333984 },
                { -295.999207, -350.000000, -1353.331055 } } } },

    /** Patch 52 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -311.999786, -500.000214, -1363.333984 },
                { -323.999908, -500.000214, -1349.999023 },
                { -311.999786, -350.000000, -1363.333984 } } } },

    /** Patch 53 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -323.999908, -500.000214, -1349.999023 },
                { -308.000000, -500.000214, -1340.002930 },
                { -323.999908, -350.000000, -1349.999023 } } } },

    /** Patch 54 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -308.000000, -666.666687, -1340.002930 },
                { -295.999207, -666.666687, -1353.331055 },
                { -308.000000, -533.332825, -1340.002930 } } } },

    /** Patch 55 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -295.999207, -666.666687, -1353.331055 },
                { -311.999786, -666.666687, -1363.333984 },
                { -295.999207, -533.332825, -1353.331055 } } } },

    /** Patch 56 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -311.999786, -666.666687, -1363.333984 },
                { -323.999908, -666.666687, -1349.999023 },
                { -311.999786, -533.332825, -1363.333984 } } } },

    /** Patch 57 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -323.999908, -666.666687, -1349.999023 },
                { -308.000000, -666.666687, -1340.002930 },
                { -323.999908, -533.332825, -1349.999023 } } } },

    /** Patch 58 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 433.708832, -566.666809, -844.088013 },
                { 298.470917, -566.666809, -602.406677 },
                { 424.914001, -534.328918, -847.503967 } } } },

    /** Patch 59 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 298.470917, -566.666809, -602.406677 },
                { 509.488007, -518.146973, -520.407959 },
                { 289.676117, -534.328918, -605.824768 } } } },

    /** Patch 60 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 644.725891, -518.146973, -762.090027 },
                { 433.708832, -566.666809, -844.088013 },
                { 635.931091, -485.809113, -765.505981 } } } },

    /** Patch 61 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 433.708832, -566.666809, -844.088013 },
                { 644.725891, -518.146973, -762.090027 },
                { 298.470917, -566.666809, -602.406677 } } } },

    /** Patch 62 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 509.488007, -518.146973, -520.407959 },
                { 644.725891, -518.146973, -762.090027 },
                { 500.693207, -485.809113, -523.825378 } } } },

    /** Patch 63 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 289.676117, -534.328918, -605.824768 },
                { 500.693207, -485.809113, -523.825378 },
                { 424.914001, -534.328918, -847.503967 } } } },

    /** Patch 64 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 188.395203, -633.333435, -957.802979 },
                { 356.457520, -695.767822, -892.500000 },
                { 36.252300, -633.333435, -685.912537 } } } },

    /** Patch 65 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 36.252300, -633.333435, -685.912537 },
                { 204.315292, -695.767822, -620.605286 },
                { 49.833000, -602.427002, -680.635193 } } } },

    /** Patch 66 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 356.457520, -695.767822, -892.500000 },
                { 188.395203, -633.333435, -957.802979 },
                { 370.038208, -664.861389, -887.221985 } } } },

    /** Patch 67 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 204.315292, -695.767822, -620.605286 },
                { 356.457520, -695.767822, -892.500000 },
                { 217.895294, -664.861389, -615.328003 } } } },

    /** Patch 68 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 188.395203, -633.333435, -957.802979 },
                { 36.252300, -633.333435, -685.912537 },
                { 201.975204, -602.427002, -952.524963 } } } },

    /** Patch 69 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { 49.833000, -602.427002, -680.635193 },
                { 217.895294, -664.861389, -615.328003 },
                { 201.975204, -602.427002, -952.524963 } } } },

    /** Patch 70 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 650.722107, -800.002014, -689.105164 },
                { 580.434387, -800.002014, -563.493713 },
                { 533.348206, -541.608887, -785.043030 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 416.794708, -541.608887, -576.753113 },
                { 533.348206, -541.608887, -785.043030 },
                { 580.434387, -800.002014, -563.493713 } } } },

    /** Patch 71 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 650.722107, -800.002014, -689.105164 },
                { 533.348206, -541.608887, -785.043030 },
                { 689.917908, -800.002014, -670.970276 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 568.779419, -533.325073, -769.986023 },
                { 689.917908, -800.002014, -670.970276 },
                { 533.348206, -541.608887, -785.043030 } } } },

    /** Patch 72 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 416.794708, -541.608887, -576.753113 },
                { 580.434387, -800.002014, -563.493713 },
                { 453.411713, -533.325073, -563.813599 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 622.298584, -800.002014, -550.129272 },
                { 453.411713, -533.325073, -563.813599 },
                { 580.434387, -800.002014, -563.493713 } } } },

    /** Patch 73 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 622.298584, -800.002014, -550.129272 },
                { 689.917908, -800.002014, -670.970276 },
                { 453.411713, -533.325073, -563.813599 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 568.779419, -533.325073, -769.986023 },
                { 453.411713, -533.325073, -563.813599 },
                { 689.917908, -800.002014, -670.970276 } } } },

    /** Patch 74 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 67.053001, -800.002014, -725.025024 },
                { 172.239197, -800.002014, -913.003052 },
                { 147.604797, -670.852722, -665.175659 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 279.033295, -670.852722, -900.052979 },
                { 147.604797, -670.852722, -665.175659 },
                { 172.239197, -800.002014, -913.003052 } } } },

    /** Patch 75 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 279.033295, -670.852722, -900.052979 },
                { 172.239197, -800.002014, -913.003052 },
                { 244.124313, -658.100830, -912.344971 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 126.785400, -800.002014, -926.576050 },
                { 244.124313, -658.100830, -912.344971 },
                { 172.239197, -800.002014, -913.003052 } } } },

    /** Patch 76 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 67.053001, -800.002014, -725.025024 },
                { 147.604797, -670.852722, -665.175659 },
                { 25.356800, -800.002014, -745.317932 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.862701, -658.100830, -679.557190 },
                { 25.356800, -800.002014, -745.317932 },
                { 147.604797, -670.852722, -665.175659 } } } },

    /** Patch 77 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 126.785400, -800.002014, -926.576050 },
                { 25.356800, -800.002014, -745.317932 },
                { 244.124313, -658.100830, -912.344971 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 113.862701, -658.100830, -679.557190 },
                { 244.124313, -658.100830, -912.344971 },
                { 25.356800, -800.002014, -745.317932 } } } },

    /** Patch 78 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 185.036591, -766.667969, -883.266968 },
                { 102.610901, -766.667969, -735.966003 },
                { 623.555115, -766.667969, -679.991882 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 571.348389, -766.667969, -586.693787 },
                { 623.555115, -766.667969, -679.991882 },
                { 102.610901, -766.667969, -735.966003 } } } },

    /** Patch 79 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 641.077515, -800.002014, -671.869080 },
                { 161.664307, -800.002014, -894.102966 },
                { 623.555115, -766.667969, -679.991882 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 185.036591, -766.667969, -883.266968 },
                { 623.555115, -766.667969, -679.991882 },
                { 161.664307, -800.002014, -894.102966 } } } },

    /** Patch 80 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 77.628601, -800.002014, -743.924988 },
                { 590.078308, -800.002014, -580.729065 },
                { 102.610901, -766.667969, -735.966003 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { 571.348389, -766.667969, -586.693787 },
                { 102.610901, -766.667969, -735.966003 },
                { 590.078308, -800.002014, -580.729065 } } } },

    /** Patch 81 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, -66.666603, -1699.999023 },
                { -840.000061, -66.666603, -1699.999023 },
                { -360.000183, -66.666603, -1400.000000 } } } },

    /** Patch 82 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, -233.333084, -1699.999023 },
                { -840.000061, -233.333084, -1699.999023 },
                { -479.999817, -233.333084, -1299.997925 } } } },

    /** Patch 83 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, -266.666412, -1299.997925 },
                { -840.000061, -266.666412, -1299.997925 },
                { -479.999817, -266.666412, -1699.999023 } } } },

    /** Patch 84 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, -266.666412, -1699.999023 },
                { -840.000061, -266.666412, -1699.999023 },
                { -479.999817, -233.333084, -1699.999023 } } } },

    /** Patch 85 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -266.666412, -1699.999023 },
                { -840.000061, -266.666412, -1299.997925 },
                { -840.000061, -233.333084, -1699.999023 } } } },

    /** Patch 86 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -266.666412, -1299.997925 },
                { -479.999817, -266.666412, -1299.997925 },
                { -840.000061, -233.333084, -1299.997925 } } } },

    /** Patch 87 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, -266.666412, -1299.997925 },
                { -479.999817, -266.666412, -1699.999023 },
                { -479.999817, -233.333084, -1299.997925 } } } },

    /** Patch 88 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -800.002014, -1699.999023 },
                { -840.000061, -800.002014, -1699.999023 },
                { -800.002014, -266.666412, -1699.999023 } } } },

    /** Patch 89 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -800.002014, -1699.999023 },
                { -840.000061, -800.002014, -1666.665039 },
                { -840.000061, -266.666412, -1699.999023 } } } },

    /** Patch 90 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -800.002014, -1666.665039 },
                { -800.002014, -800.002014, -1666.665039 },
                { -840.000061, -266.666412, -1666.665039 } } } },

    /** Patch 91 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -800.002014, -1666.665039 },
                { -800.002014, -800.002014, -1699.999023 },
                { -800.002014, -266.666412, -1666.665039 } } } },

    /** Patch 92 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, -99.999901, -1400.000000 },
                { -840.000061, -99.999901, -1400.000000 },
                { -360.000183, -99.999901, -1699.999023 } } } },

    /** Patch 93 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, -99.999901, -1699.999023 },
                { -840.000061, -99.999901, -1699.999023 },
                { -360.000183, -66.666603, -1699.999023 } } } },

    /** Patch 94 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -99.999901, -1699.999023 },
                { -840.000061, -99.999901, -1400.000000 },
                { -840.000061, -66.666603, -1699.999023 } } } },

    /** Patch 95 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -99.999901, -1400.000000 },
                { -360.000183, -99.999901, -1400.000000 },
                { -840.000061, -66.666603, -1400.000000 } } } },

    /** Patch 96 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, -99.999901, -1400.000000 },
                { -360.000183, -99.999901, -1699.999023 },
                { -360.000183, -66.666603, -1400.000000 } } } },

    /** Patch 97 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -233.333084, -1699.999023 },
                { -840.000061, -233.333084, -1699.999023 },
                { -800.002014, -99.999901, -1699.999023 } } } },

    /** Patch 98 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -233.333084, -1699.999023 },
                { -840.000061, -233.333084, -1666.665039 },
                { -840.000061, -99.999901, -1699.999023 } } } },

    /** Patch 99 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -233.333084, -1666.665039 },
                { -800.002014, -233.333084, -1666.665039 },
                { -840.000061, -99.999901, -1666.665039 } } } },

    /** Patch 100 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -233.333084, -1666.665039 },
                { -800.002014, -233.333084, -1699.999023 },
                { -800.002014, -99.999901, -1666.665039 } } } },

    /** Patch 101 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, 400.000305, -1699.999023 },
                { -840.000061, 400.000305, -1699.999023 },
                { -800.002014, 400.000305, -1666.665039 } } } },

    /** Patch 102 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, 99.999901, -1699.999023 },
                { -840.000061, 99.999901, -1699.999023 },
                { -479.999817, 99.999901, -1299.997925 } } } },

    /** Patch 103 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, 66.666603, -1299.997925 },
                { -840.000061, 66.666603, -1299.997925 },
                { -479.999817, 66.666603, -1699.999023 } } } },

    /** Patch 104 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, 66.666603, -1699.999023 },
                { -840.000061, 66.666603, -1699.999023 },
                { -479.999817, 99.999901, -1699.999023 } } } },

    /** Patch 105 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 66.666603, -1699.999023 },
                { -840.000061, 66.666603, -1299.997925 },
                { -840.000061, 99.999901, -1699.999023 } } } },

    /** Patch 106 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 66.666603, -1299.997925 },
                { -479.999817, 66.666603, -1299.997925 },
                { -840.000061, 99.999901, -1299.997925 } } } },

    /** Patch 107 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -479.999817, 66.666603, -1299.997925 },
                { -479.999817, 66.666603, -1699.999023 },
                { -479.999817, 99.999901, -1299.997925 } } } },

    /** Patch 108 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -66.666603, -1699.999023 },
                { -840.000061, -66.666603, -1699.999023 },
                { -800.002014, 66.666603, -1699.999023 } } } },

    /** Patch 109 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -66.666603, -1699.999023 },
                { -840.000061, -66.666603, -1666.665039 },
                { -840.000061, 66.666603, -1699.999023 } } } },

    /** Patch 110 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, -66.666603, -1666.665039 },
                { -800.002014, -66.666603, -1666.665039 },
                { -840.000061, 66.666603, -1666.665039 } } } },

    /** Patch 111 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, -66.666603, -1666.665039 },
                { -800.002014, -66.666603, -1699.999023 },
                { -800.002014, 66.666603, -1666.665039 } } } },

    /** Patch 112 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, 233.333084, -1400.000000 },
                { -360.000183, 233.333084, -1699.999023 },
                { -360.000183, 266.666412, -1400.000000 } } } },

    /** Patch 113 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, 266.666412, -1699.999023 },
                { -840.000061, 266.666412, -1699.999023 },
                { -360.000183, 266.666412, -1400.000000 } } } },

    /** Patch 114 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, 233.333084, -1400.000000 },
                { -840.000061, 233.333084, -1400.000000 },
                { -360.000183, 233.333084, -1699.999023 } } } },

    /** Patch 115 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -360.000183, 233.333084, -1699.999023 },
                { -840.000061, 233.333084, -1699.999023 },
                { -360.000183, 266.666412, -1699.999023 } } } },

    /** Patch 116 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 233.333084, -1699.999023 },
                { -840.000061, 233.333084, -1400.000000 },
                { -840.000061, 266.666412, -1699.999023 } } } },

    /** Patch 117 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 233.333084, -1400.000000 },
                { -360.000183, 233.333084, -1400.000000 },
                { -840.000061, 266.666412, -1400.000000 } } } },

    /** Patch 118 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, 99.999901, -1699.999023 },
                { -840.000061, 99.999901, -1699.999023 },
                { -800.002014, 233.333084, -1699.999023 } } } },

    /** Patch 119 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 99.999901, -1699.999023 },
                { -840.000061, 99.999901, -1666.665039 },
                { -840.000061, 233.333084, -1699.999023 } } } },

    /** Patch 120 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 99.999901, -1666.665039 },
                { -800.002014, 99.999901, -1666.665039 },
                { -840.000061, 233.333084, -1666.665039 } } } },

    /** Patch 121 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, 99.999901, -1666.665039 },
                { -800.002014, 99.999901, -1699.999023 },
                { -800.002014, 233.333084, -1666.665039 } } } },

    /** Patch 122 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, 266.666412, -1699.999023 },
                { -840.000061, 266.666412, -1699.999023 },
                { -800.002014, 400.000305, -1699.999023 } } } },

    /** Patch 123 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 266.666412, -1699.999023 },
                { -840.000061, 266.666412, -1666.665039 },
                { -840.000061, 400.000305, -1699.999023 } } } },

    /** Patch 124 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -840.000061, 266.666412, -1666.665039 },
                { -800.002014, 266.666412, -1666.665039 },
                { -840.000061, 400.000305, -1666.665039 } } } },

    /** Patch 125 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -800.002014, 266.666412, -1666.665039 },
                { -800.002014, 266.666412, -1699.999023 },
                { -800.002014, 400.000305, -1666.665039 } } } },

    /** Patch 126 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 392.043396, 243.630798, -1051.567993 },
                { 242.694885, 183.257202, -1015.875000 },
                { 510.173309, 243.630798, -708.260010 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 398.162109, 198.350601, -681.492676 },
                { 510.173309, 243.630798, -708.260010 },
                { 242.694885, 183.257202, -1015.875000 } } } },

    /** Patch 127 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 396.395996, 235.538788, -1052.604004 },
                { 512.350281, 239.584793, -708.778015 },
                { 247.047501, 175.165207, -1016.917969 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 400.338379, 194.304596, -682.012085 },
                { 247.047501, 175.165207, -1016.917969 },
                { 512.350281, 239.584793, -708.778015 } } } },

    /** Patch 128 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 356.604492, 243.630798, -1154.558960 },
                { 238.473892, 243.630798, -1497.867065 },
                { 207.255997, 183.257202, -1118.873047 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 126.462692, 198.350601, -1471.098877 },
                { 207.255997, 183.257202, -1118.873047 },
                { 238.473892, 243.630798, -1497.867065 } } } },

    /** Patch 129 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 360.957123, 235.538788, -1155.595093 },
                { 211.608612, 175.165207, -1119.908936 },
                { 240.650208, 239.584793, -1498.384888 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 128.639008, 194.304596, -1471.616943 },
                { 240.650208, 239.584793, -1498.384888 },
                { 211.608612, 175.165207, -1119.908936 } } } },

    /** Patch 130 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 312.337189, 53.784500, -1032.520996 },
                { 461.685730, 114.158798, -1068.207031 },
                { 467.804382, 68.877899, -698.133789 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 579.816284, 114.158798, -724.899048 },
                { 467.804382, 68.877899, -698.133789 },
                { 461.685730, 114.158798, -1068.207031 } } } },

    /** Patch 131 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 308.116211, 114.158798, -1514.505981 },
                { 426.246765, 114.158798, -1171.197998 },
                { 196.104996, 68.877899, -1487.744995 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 276.898285, 53.784500, -1135.511963 },
                { 196.104996, 68.877899, -1487.744995 },
                { 426.246765, 114.158798, -1171.197998 } } } },

    /** Patch 132 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 765.387024, 266.184113, -1215.088013 },
                { 777.203064, 266.184113, -1180.753052 },
                { 426.246765, 114.158798, -1171.197998 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 461.685730, 114.158798, -1068.207031 },
                { 426.246765, 114.158798, -1171.197998 },
                { 777.203064, 266.184113, -1180.753052 } } } },

    /** Patch 133 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 777.203064, 266.184113, -1180.753052 },
                { 759.794006, 298.552094, -1176.594971 },
                { 461.685730, 114.158798, -1068.207031 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 426.864197, 178.894806, -1059.884033 },
                { 461.685730, 114.158798, -1068.207031 },
                { 759.794006, 298.552094, -1176.594971 } } } },

    /** Patch 134 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 759.794006, 298.552094, -1176.594971 },
                { 747.977966, 298.552094, -1210.922974 },
                { 426.864197, 178.894806, -1059.884033 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 391.425293, 178.894806, -1162.881958 },
                { 426.864197, 178.894806, -1059.884033 },
                { 747.977966, 298.552094, -1210.922974 } } } },

    /** Patch 135 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 747.977966, 298.552094, -1210.922974 },
                { 765.387024, 266.184113, -1215.088013 },
                { 391.425293, 178.894806, -1162.881958 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 426.246765, 114.158798, -1171.197998 },
                { 391.425293, 178.894806, -1162.881958 },
                { 765.387024, 266.184113, -1215.088013 } } } },

    /** Patch 136 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 765.387024, 266.184113, -1215.088013 },
                { 747.977966, 298.552094, -1210.922974 },
                { 777.203064, 266.184113, -1180.753052 } } } },

    /** Patch 137 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 426.246765, 114.158798, -1171.197998 },
                { 276.898285, 53.784500, -1135.511963 },
                { 391.425293, 178.894806, -1162.881958 } } } },

    /** Patch 138 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 312.337189, 53.784500, -1032.520996 },
                { 461.685730, 114.158798, -1068.207031 },
                { 277.516418, 118.520500, -1024.197998 } } } },

    /** Patch 139 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 391.425293, 178.894806, -1162.881958 },
                { 242.076797, 118.520500, -1127.188965 },
                { 426.864197, 178.894806, -1059.884033 } } } },

    /** Patch 140 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 461.685730, 114.158798, -1068.207031 },
                { 312.337189, 53.784500, -1032.520996 },
                { 426.246765, 114.158798, -1171.197998 } } } },

    /** Patch 141 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 242.669006, 54.875099, -1090.179932 },
                { 254.482208, 54.875099, -1055.844971 },
                { 225.257904, 87.243103, -1086.021973 } } } },

    /** Patch 142 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 242.076797, 118.520500, -1127.188965 },
                { 225.257904, 87.243103, -1086.021973 },
                { 277.516418, 118.520500, -1024.197998 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 237.071091, 87.243103, -1051.687012 },
                { 277.516418, 118.520500, -1024.197998 },
                { 225.257904, 87.243103, -1086.021973 } } } },

    /** Patch 143 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 242.669006, 54.875099, -1090.179932 },
                { 276.898285, 53.784500, -1135.511963 },
                { 254.482208, 54.875099, -1055.844971 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 312.337189, 53.784500, -1032.520996 },
                { 254.482208, 54.875099, -1055.844971 },
                { 276.898285, 53.784500, -1135.511963 } } } },

    /** Patch 144 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 242.076797, 118.520500, -1127.188965 },
                { 276.898285, 53.784500, -1135.511963 },
                { 225.257904, 87.243103, -1086.021973 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 242.669006, 54.875099, -1090.179932 },
                { 225.257904, 87.243103, -1086.021973 },
                { 276.898285, 53.784500, -1135.511963 } } } },

    /** Patch 145 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 312.337189, 53.784500, -1032.520996 },
                { 277.516418, 118.520500, -1024.197998 },
                { 254.482208, 54.875099, -1055.844971 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 237.071091, 87.243103, -1051.687012 },
                { 254.482208, 54.875099, -1055.844971 },
                { 277.516418, 118.520500, -1024.197998 } } } },

    /** Patch 146 **/
    { MODEL_RECTANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 356.604492, 243.630798, -1154.558960 },
                { 207.255997, 183.257202, -1118.873047 },
                { 392.043396, 243.630798, -1051.567993 } } } },

    /** Patch 147 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 752.408997, 298.552094, -1198.050049 },
                { 675.556702, 272.411285, -1179.688965 },
                { 717.583984, 363.288818, -1189.727051 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 680.249512, 348.194702, -1180.808960 },
                { 717.583984, 363.288818, -1189.727051 },
                { 675.556702, 272.411285, -1179.688965 } } } },

    /** Patch 148 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 678.510010, 272.411285, -1171.106934 },
                { 755.362976, 298.552094, -1189.468018 },
                { 683.202820, 348.194702, -1172.227051 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 720.538025, 363.288818, -1181.145020 },
                { 683.202820, 348.194702, -1172.227051 },
                { 755.362976, 298.552094, -1189.468018 } } } },

    /** Patch 149 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 758.855957, 278.322113, -1213.526978 },
                { 681.231567, 248.135315, -1204.265991 },
                { 723.421997, 278.322113, -1316.518066 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 686.083313, 263.228699, -1307.593018 },
                { 723.421997, 278.322113, -1316.518066 },
                { 681.231567, 248.135315, -1204.265991 } } } },

    /** Patch 150 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 676.879028, 256.227295, -1203.223022 },
                { 754.509033, 286.414093, -1212.484009 },
                { 681.730652, 271.320679, -1306.557007 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 719.068054, 286.414093, -1315.474976 },
                { 681.730652, 271.320679, -1306.557007 },
                { 754.509033, 286.414093, -1212.484009 } } } },

    /** Patch 151 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 766.317993, 286.414093, -1178.156006 },
                { 694.598816, 256.227295, -1151.730957 },
                { 801.759033, 286.414093, -1075.164917 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 764.421021, 271.320679, -1066.239990 },
                { 801.759033, 286.414093, -1075.164917 },
                { 694.598816, 256.227295, -1151.730957 } } } },

    /** Patch 152 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 698.951416, 248.135315, -1152.767090 },
                { 770.671997, 278.322113, -1179.192017 },
                { 768.775024, 263.228699, -1067.283081 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 806.112976, 278.322113, -1076.201050 },
                { 768.775024, 263.228699, -1067.283081 },
                { 770.671997, 278.322113, -1179.192017 } } } },

    /** Patch 153 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 577.639282, 118.204796, -724.380981 },
                { 457.333099, 122.250793, -1067.164062 },
                { 465.628113, 72.923897, -697.613708 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 307.984589, 61.876499, -1031.477905 },
                { 465.628113, 72.923897, -697.613708 },
                { 457.333099, 122.250793, -1067.164062 } } } },

    /** Patch 154 **/
    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 272.545715, 61.876499, -1134.468994 },
                { 421.894196, 122.250793, -1170.161987 },
                { 193.928696, 72.923897, -1487.219971 } } } },

    { MODEL_TRIANGLE,
        { { 0.941176, 0.125490, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 305.939880, 118.204796, -1513.987915 },
                { 193.928696, 72.923897, -1487.219971 },
                { 421.894196, 122.250793, -1170.161987 } } } },

    /** Patch 155 **/
    { MODEL_RECTANGLE,
        { { 1.000000, 1.000000, 1.000000 }, { 400.000000, 400.000000, 400.000000 },
            { { -229.925507, 290.945190, -1623.173950 },
                { -297.808014, 290.945190, -1566.606934 },
                { -258.613617, 218.439896, -1647.078979 } } } },

    /** Patch 156 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -329.024506, 295.358704, -1620.905884 },
                { -343.368195, 259.105713, -1632.854980 },
                { -297.808014, 290.945190, -1566.606934 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -326.496094, 218.439896, -1590.512085 },
                { -297.808014, 290.945190, -1566.606934 },
                { -343.368195, 259.105713, -1632.854980 } } } },

    /** Patch 157 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -343.368195, 259.105713, -1632.854980 },
                { -309.427307, 259.105713, -1661.141968 },
                { -326.496094, 218.439896, -1590.512085 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -258.613617, 218.439896, -1647.078979 },
                { -326.496094, 218.439896, -1590.512085 },
                { -309.427307, 259.105713, -1661.141968 } } } },

    /** Patch 158 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -309.427307, 259.105713, -1661.141968 },
                { -295.082886, 295.358704, -1649.185913 },
                { -258.613617, 218.439896, -1647.078979 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -229.925507, 290.945190, -1623.173950 },
                { -258.613617, 218.439896, -1647.078979 },
                { -295.082886, 295.358704, -1649.185913 } } } },

    /** Patch 159 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -295.082886, 295.358704, -1649.185913 },
                { -329.024506, 295.358704, -1620.905884 },
                { -229.925507, 290.945190, -1623.173950 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -297.808014, 290.945190, -1566.606934 },
                { -229.925507, 290.945190, -1623.173950 },
                { -329.024506, 295.358704, -1620.905884 } } } },

    /** Patch 160 **/
    { MODEL_RECTANGLE,
        { { 1.000000, 1.000000, 1.000000 }, { 400.000000, 400.000000, 400.000000 },
            { { -651.277222, 370.474304, -1217.432983 },
                { -691.848511, 370.474304, -1144.927002 },
                { -694.779419, 301.192505, -1234.338013 } } } },

    /** Patch 161 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -742.811951, 379.820679, -1186.801025 },
                { -764.567993, 345.179810, -1195.250000 },
                { -691.848511, 370.474304, -1144.927002 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -735.350037, 301.192505, -1161.832031 },
                { -691.848511, 370.474304, -1144.927002 },
                { -764.567993, 345.179810, -1195.250000 } } } },

    /** Patch 162 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -764.567993, 345.179810, -1195.250000 },
                { -744.281982, 345.179810, -1231.502930 },
                { -735.350037, 301.192505, -1161.832031 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -694.779419, 301.192505, -1234.338013 },
                { -735.350037, 301.192505, -1161.832031 },
                { -744.281982, 345.179810, -1231.502930 } } } },

    /** Patch 163 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -744.281982, 345.179810, -1231.502930 },
                { -722.525940, 379.820679, -1223.046997 },
                { -694.779419, 301.192505, -1234.338013 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -651.277222, 370.474304, -1217.432983 },
                { -694.779419, 301.192505, -1234.338013 },
                { -722.525940, 379.820679, -1223.046997 } } } },

    /** Patch 164 **/
    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -722.525940, 379.820679, -1223.046997 },
                { -742.811951, 379.820679, -1186.801025 },
                { -651.277222, 370.474304, -1217.432983 } } } },

    { MODEL_TRIANGLE,
        { { 0.373419, 0.373419, 0.373419 }, { 0.000000, 0.000000, 0.000000 },
            { { -691.848511, 370.474304, -1144.927002 },
                { -651.277222, 370.474304, -1217.432983 },
                { -742.811951, 379.820679, -1186.801025 } } } },

    /** Patch 165 **/
    { MODEL_RECTANGLE,
        { { 0.186700, 0.186700, 0.186700 }, { 0.000000, 0.000000, 0.000000 },
            { { -420.000031, 654.000183, -999.999023 },
                { 420.000031, 654.000183, -999.999023 },
                { -420.000031, 600.000061, -999.999023 } } } },

    /** Patch 166 **/
    { MODEL_RECTANGLE,
        { { 0.186700, 0.186700, 0.186700 }, { 0.000000, 0.000000, 0.000000 },
            { { 420.000031, 654.000183, -999.999023 },
                { 420.000031, 654.000183, -700.000000 },
                { 420.000031, 600.000061, -999.999023 } } } },

    /** Patch 167 **/
    { MODEL_RECTANGLE,
        { { 0.186700, 0.186700, 0.186700 }, { 0.000000, 0.000000, 0.000000 },
            { { 420.000031, 654.000183, -700.000000 },
                { -420.000031, 654.000183, -700.000000 },
                { 420.000031, 600.000061, -700.000000 } } } },

    /** Patch 168 **/
    { MODEL_RECTANGLE,
        { { 0.186700, 0.186700, 0.186700 }, { 0.000000, 0.000000, 0.000000 },
            { { -420.000031, 654.000183, -700.000000 },
                { -420.000031, 654.000183, -999.999023 },
                { -420.000031, 600.000061, -700.000000 } } } },

    /** Patch 169 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 120.000000, 120.000000, 120.000000 },
            { { -264.000092, 628.000122, -850.002991 },
                { -264.000092, 628.000122, -890.001038 },
                { -215.999710, 628.000122, -850.002991 } } } },

    /** Patch 170 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 60.000000, 60.000000, 60.000000 },
            { { -264.000092, 631.333496, -890.001038 },
                { -264.000092, 631.333496, -850.002991 },
                { -215.999710, 631.333496, -890.001038 } } } },

    /** Patch 171 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 120.000000, 120.000000, 120.000000 },
            { { -24.000200, 628.000122, -850.002991 },
                { -24.000200, 628.000122, -890.001038 },
                { 24.000200, 628.000122, -850.002991 } } } },

    /** Patch 172 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 60.000000, 60.000000, 60.000000 },
            { { -24.000200, 631.333496, -890.001038 },
                { -24.000200, 631.333496, -850.002991 },
                { 24.000200, 631.333496, -890.001038 } } } },

    /** Patch 173 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 120.000000, 120.000000, 120.000000 },
            { { 215.999710, 628.000122, -850.002991 },
                { 215.999710, 628.000122, -890.001038 },
                { 264.000092, 628.000122, -850.002991 } } } },

    /** Patch 174 **/
    { MODEL_RECTANGLE,
        { { 0.000000, 0.000000, 0.000000 }, { 60.000000, 60.000000, 60.000000 },
            { { 215.999710, 631.333496, -890.001038 },
                { 215.999710, 631.333496, -850.002991 },
                { 264.000092, 631.333496, -890.001038 } } } },

    /** Patch 0 **/
    { MODEL_RECTANGLE,
        { { 0.615686, 0.737255, 0.870588 }, { 0.000000, 0.000000, 0.000000 },
            { { 847.000000, -800.002014, 1701.000000 },
                { -847.000000, -800.002014, 1701.000000 },
                { 847.000000, 800.002014, 1701.000000 } } } },

    /** Patch 1 **/
    { MODEL_RECTANGLE,
        { { 0.615686, 0.737255, 0.870588 }, { 0.000000, 0.000000, 0.000000 },
            { { -847.000000, -800.002014, 1701.000000 },
                { -847.000000, -800.002014, 0.000000 },
                { -847.000000, 800.002014, 1701.000000 } } } },

    /** Patch 2 **/
    { MODEL_RECTANGLE,
        { { 0.615686, 0.737255, 0.870588 }, { 0.000000, 0.000000, 0.000000 },
            { { 847.000000, -800.002014, 0.000000 },
                { 847.000000, -800.002014, 1701.000000 },
                { 847.000000, 800.002014, 0.000000 } } } },

    /** Patch 3 **/
    { MODEL_RECTANGLE,
        { { 0.603921, 0.603921, 0.603921 }, { 0.000000, 0.000000, 0.000000 },
            { { -847.000000, 800.002014, 0.000000 },
                { 847.000000, 800.002014, 0.000000 },
                { -847.000000, 800.002014, 1701.000000 } } } },

    /** Patch 4 **/
    { MODEL_RECTANGLE,
        { { 0.501961, 0.501961, 0.501961 }, { 0.000000, 0.000000, 0.000000 },
            { { -847.000000, -800.002014, 1701.000000 },
                { 847.000000, -800.002014, 1701.000000 },
                { -847.000000, -800.002014, 0.000000 } } } },

    /** Patch 5 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 84.000000, -350.000000, 1699.999023 },
                { 840.000061, -350.000000, 859.998962 },
                { 84.000000, -299.999695, 1699.999023 } } } },

    /** Patch 6 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 840.000061, -350.000000, 859.998962 },
                { 84.000000, -350.000000, 1699.999023 },
                { 336.000000, -350.000000, 544.999695 } } } },

    /** Patch 7 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 336.000000, -299.999695, 544.999695 },
                { -420.000031, -299.999695, 1384.999023 },
                { 840.000061, -299.999695, 859.998962 } } } },

    /** Patch 8 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 336.000000, -350.000000, 544.999695 },
                { -420.000031, -350.000000, 1384.999023 },
                { 336.000000, -299.999695, 544.999695 } } } },

    /** Patch 9 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -420.000031, -350.000000, 1384.999023 },
                { 84.000000, -350.000000, 1699.999023 },
                { -420.000031, -299.999695, 1384.999023 } } } },

    /** Patch 10 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 840.000061, -350.000000, 859.998962 },
                { 336.000000, -350.000000, 544.999695 },
                { 840.000061, -299.999695, 859.998962 } } } },

    /** Patch 11 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 306.000092, -800.002014, 619.999817 },
                { 786.001953, -800.002014, 920.003052 },
                { 306.000092, -350.000000, 619.999817 } } } },

    /** Patch 12 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 341.999695, -800.002014, 579.999695 },
                { 306.000092, -800.002014, 619.999817 },
                { 341.999695, -350.000000, 579.999695 } } } },

    /** Patch 13 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 786.001953, -800.002014, 920.003052 },
                { 822.002930, -800.002014, 879.998047 },
                { 786.001953, -350.000000, 920.003052 } } } },

    /** Patch 14 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 822.002930, -800.002014, 879.998047 },
                { 341.999695, -800.002014, 579.999695 },
                { 822.002930, -350.000000, 879.998047 } } } },

    /** Patch 15 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -113.999901, -533.332825, 1045.001953 },
                { -420.000031, -533.332825, 1384.999023 },
                { -113.999901, -500.000214, 1045.001953 } } } },

    /** Patch 16 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -420.000031, -533.332825, 1384.999023 },
                { 84.000000, -533.332825, 1699.999023 },
                { -420.000031, -500.000214, 1384.999023 } } } },

    /** Patch 17 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -113.999901, -500.000214, 1045.001953 },
                { -420.000031, -500.000214, 1384.999023 },
                { 390.000092, -500.000214, 1360.001953 } } } },

    /** Patch 18 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 390.000092, -533.332825, 1360.001953 },
                { 84.000000, -533.332825, 1699.999023 },
                { -113.999901, -533.332825, 1045.001953 } } } },

    /** Patch 19 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 84.000000, -533.332825, 1699.999023 },
                { 390.000092, -533.332825, 1360.001953 },
                { 84.000000, -500.000214, 1699.999023 } } } },

    /** Patch 20 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 390.000092, -533.332825, 1360.001953 },
                { -113.999901, -533.332825, 1045.001953 },
                { 390.000092, -500.000214, 1360.001953 } } } },

    /** Patch 21 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -113.999901, -700.000000, 1045.001953 },
                { -420.000031, -700.000000, 1384.999023 },
                { -113.999901, -666.666687, 1045.001953 } } } },

    /** Patch 22 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -420.000031, -700.000000, 1384.999023 },
                { 84.000000, -700.000000, 1699.999023 },
                { -420.000031, -666.666687, 1384.999023 } } } },

    /** Patch 23 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { -113.999901, -666.666687, 1045.001953 },
                { -420.000031, -666.666687, 1384.999023 },
                { 390.000092, -666.666687, 1360.001953 } } } },

    /** Patch 24 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 390.000092, -700.000000, 1360.001953 },
                { 84.000000, -700.000000, 1699.999023 },
                { -113.999901, -700.000000, 1045.001953 } } } },

    /** Patch 25 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 84.000000, -700.000000, 1699.999023 },
                { 390.000092, -700.000000, 1360.001953 },
                { 84.000000, -666.666687, 1699.999023 } } } },

    /** Patch 26 **/
    { MODEL_RECTANGLE,
        { { 0.464516, 0.076674, 0.000000 }, { 0.000000, 0.000000, 0.000000 },
            { { 390.000092, -700.000000, 1360.001953 },
                { -113.999901, -700.000000, 1045.001953 },
                { 390.000092, -666.666687, 1360.001953 } } } },

    /** Patch 27 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 138.000107, -500.000214, 1640.001953 },
                { -341.999695, -500.000214, 1340.002930 },
                { 138.000107, -350.000000, 1640.001953 } } } },

    /** Patch 28 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -341.999695, -500.000214, 1340.002930 },
                { -378.000000, -500.000214, 1380.000977 },
                { -341.999695, -350.000000, 1340.002930 } } } },

    /** Patch 29 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -378.000000, -500.000214, 1380.000977 },
                { 101.999802, -500.000214, 1680.000122 },
                { -378.000000, -350.000000, 1380.000977 } } } },

    /** Patch 30 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 101.999802, -500.000214, 1680.000122 },
                { 138.000107, -500.000214, 1640.001953 },
                { 101.999802, -350.000000, 1680.000122 } } } },

    /** Patch 31 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 138.000107, -666.666687, 1640.001953 },
                { -341.999695, -666.666687, 1340.002930 },
                { 138.000107, -533.332825, 1640.001953 } } } },

    /** Patch 32 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -341.999695, -666.666687, 1340.002930 },
                { -378.000000, -666.666687, 1380.000977 },
                { -341.999695, -533.332825, 1340.002930 } } } },

    /** Patch 33 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -378.000000, -666.666687, 1380.000977 },
                { 101.999802, -666.666687, 1680.000122 },
                { -378.000000, -533.332825, 1380.000977 } } } },

    /** Patch 34 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 101.999802, -666.666687, 1680.000122 },
                { 138.000107, -666.666687, 1640.001953 },
                { 101.999802, -533.332825, 1680.000122 } } } },

    /** Patch 35 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 138.000107, -800.002014, 1640.001953 },
                { -341.999695, -800.002014, 1340.002930 },
                { 138.000107, -700.000000, 1640.001953 } } } },

    /** Patch 36 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -341.999695, -800.002014, 1340.002930 },
                { -378.000000, -800.002014, 1380.000977 },
                { -341.999695, -700.000000, 1340.002930 } } } },

    /** Patch 37 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { -378.000000, -800.002014, 1380.000977 },
                { 101.999802, -800.002014, 1680.000122 },
                { -378.000000, -700.000000, 1380.000977 } } } },

    /** Patch 38 **/
    { MODEL_RECTANGLE,
        { { 0.682353, 0.247059, 0.011765 }, { 0.000000, 0.000000, 0.000000 },
            { { 101.999802, -800.002014, 1680.000122 },
                { 138.000107, -800.002014, 1640.001953 },
                { 101.999802, -700.000000, 1680.000122 } } } },

    /** Patch 39 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -108.000198, -500.000214, 1080.002075 },
                { -120.000298, -500.000214, 1093.337036 },
                { -108.000198, -350.000000, 1080.002075 } } } },

    /** Patch 40 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -104.000397, -500.000214, 1103.333008 },
                { -91.999603, -500.000214, 1089.998047 },
                { -104.000397, -350.000000, 1103.333008 } } } },

    /** Patch 41 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -120.000298, -500.000214, 1093.337036 },
                { -104.000397, -500.000214, 1103.333008 },
                { -120.000298, -350.000000, 1093.337036 } } } },

    /** Patch 42 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -91.999603, -500.000214, 1089.998047 },
                { -108.000198, -500.000214, 1080.002075 },
                { -91.999603, -350.000000, 1089.998047 } } } },

    /** Patch 43 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -108.000198, -666.666687, 1080.002075 },
                { -120.000298, -666.666687, 1093.337036 },
                { -108.000198, -533.332825, 1080.002075 } } } },

    /** Patch 44 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -104.000397, -666.666687, 1103.333008 },
                { -91.999603, -666.666687, 1089.998047 },
                { -104.000397, -533.332825, 1103.333008 } } } },

    /** Patch 45 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -120.000298, -666.666687, 1093.337036 },
                { -104.000397, -666.666687, 1103.333008 },
                { -120.000298, -533.332825, 1093.337036 } } } },

    /** Patch 46 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { -91.999603, -666.666687, 1089.998047 },
                { -108.000198, -666.666687, 1080.002075 },
                { -91.999603, -533.332825, 1089.998047 } } } },

    /** Patch 47 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 308.000000, -500.000214, 1340.002930 },
                { 295.999207, -500.000214, 1353.331055 },
                { 308.000000, -350.000000, 1340.002930 } } } },

    /** Patch 48 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 295.999207, -500.000214, 1353.331055 },
                { 311.999786, -500.000214, 1363.333984 },
                { 295.999207, -350.000000, 1353.331055 } } } },

    /** Patch 49 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 311.999786, -500.000214, 1363.333984 },
                { 323.999908, -500.000214, 1349.999023 },
                { 311.999786, -350.000000, 1363.333984 } } } },

    /** Patch 50 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 323.999908, -500.000214, 1349.999023 },
                { 308.000000, -500.000214, 1340.002930 },
                { 323.999908, -350.000000, 1349.999023 } } } },

    /** Patch 51 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 308.000000, -666.666687, 1340.002930 },
                { 295.999207, -666.666687, 1353.331055 },
                { 308.000000, -533.332825, 1340.002930 } } } },

    /** Patch 52 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 295.999207, -666.666687, 1353.331055 },
                { 311.999786, -666.666687, 1363.333984 },
                { 295.999207, -533.332825, 1353.331055 } } } },

    /** Patch 53 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 311.999786, -666.666687, 1363.333984 },
                { 323.999908, -666.666687, 1349.999023 },
                { 311.999786, -533.332825, 1363.333984 } } } },

    /** Patch 54 **/
    { MODEL_RECTANGLE,
        { { 0.200000, 0.200000, 0.200000 }, { 0.000000, 0.000000, 0.000000 },
            { { 323.999908, -666.666687, 1349.999023 },
                { 308.000000, -666.666687, 1340.002930 },
                { 323.999908, -533.332825, 1349.999023 } } } },

    /** Patch 55 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -433.708832, -566.666809, 844.088013 },
                { -298.470917, -566.666809, 602.406677 },
                { -424.914001, -534.328918, 847.503967 } } } },

    /** Patch 56 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -298.470917, -566.666809, 602.406677 },
                { -509.488007, -518.146973, 520.407959 },
                { -289.676117, -534.328918, 605.824768 } } } },

    /** Patch 57 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -644.725891, -518.146973, 762.090027 },
                { -433.708832, -566.666809, 844.088013 },
                { -635.931091, -485.809113, 765.505981 } } } },

    /** Patch 58 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -433.708832, -566.666809, 844.088013 },
                { -644.725891, -518.146973, 762.090027 },
                { -298.470917, -566.666809, 602.406677 } } } },

    /** Patch 59 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -509.488007, -518.146973, 520.407959 },
                { -644.725891, -518.146973, 762.090027 },
                { -500.693207, -485.809113, 523.825378 } } } },

    /** Patch 60 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -289.676117, -534.328918, 605.824768 },
                { -500.693207, -485.809113, 523.825378 },
                { -424.914001, -534.328918, 847.503967 } } } },

    /** Patch 61 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -188.395203, -633.333435, 957.802979 },
                { -356.457520, -695.767822, 892.500000 },
                { -36.252300, -633.333435, 685.912537 } } } },

    /** Patch 62 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -36.252300, -633.333435, 685.912537 },
                { -204.315292, -695.767822, 620.605286 },
                { -49.833000, -602.427002, 680.635193 } } } },

    /** Patch 63 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -356.457520, -695.767822, 892.500000 },
                { -188.395203, -633.333435, 957.802979 },
                { -370.038208, -664.861389, 887.221985 } } } },

    /** Patch 64 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -204.315292, -695.767822, 620.605286 },
                { -356.457520, -695.767822, 892.500000 },
                { -217.895294, -664.861389, 615.328003 } } } },

    /** Patch 65 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -188.395203, -633.333435, 957.802979 },
                { -36.252300, -633.333435, 685.912537 },
                { -201.975204, -602.427002, 952.524963 } } } },

    /** Patch 66 **/
    { MODEL_RECTANGLE,
        { { 0.183806, 0.551419, 0.919032 }, { 0.000000, 0.000000, 0.000000 },
            { { -49.833000, -602.427002, 680.635193 },
                { -217.895294, -664.861389, 615.328003 },
                { -201.975204, -602.427002, 952.524963 } } } },

    /** Patch 67 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -650.722107, -800.002014, 689.105164 },
                { -580.434387, -800.002014, 563.493713 },
                { -533.348206, -541.608887, 785.043030 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -416.794708, -541.608887, 576.753113 },
                { -533.348206, -541.608887, 785.043030 },
                { -580.434387, -800.002014, 563.493713 } } } },

    /** Patch 68 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -650.722107, -800.002014, 689.105164 },
                { -533.348206, -541.608887, 785.043030 },
                { -689.917908, -800.002014, 670.970276 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -568.779419, -533.325073, 769.986023 },
                { -689.917908, -800.002014, 670.970276 },
                { -533.348206, -541.608887, 785.043030 } } } },

    /** Patch 69 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -416.794708, -541.608887, 576.753113 },
                { -580.434387, -800.002014, 563.493713 },
                { -453.411713, -533.325073, 563.813599 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -622.298584, -800.002014, 550.129272 },
                { -453.411713, -533.325073, 563.813599 },
                { -580.434387, -800.002014, 563.493713 } } } },

    /** Patch 70 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -622.298584, -800.002014, 550.129272 },
                { -689.917908, -800.002014, 670.970276 },
                { -453.411713, -533.325073, 563.813599 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -568.779419, -533.325073, 769.986023 },
                { -453.411713, -533.325073, 563.813599 },
                { -689.917908, -800.002014, 670.970276 } } } },

    /** Patch 71 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -67.053001, -800.002014, 725.025024 },
                { -172.239197, -800.002014, 913.003052 },
                { -147.604797, -670.852722, 665.175659 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -279.033295, -670.852722, 900.052979 },
                { -147.604797, -670.852722, 665.175659 },
                { -172.239197, -800.002014, 913.003052 } } } },

    /** Patch 72 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -279.033295, -670.852722, 900.052979 },
                { -172.239197, -800.002014, 913.003052 },
                { -244.124313, -658.100830, 912.344971 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -126.785400, -800.002014, 926.576050 },
                { -244.124313, -658.100830, 912.344971 },
                { -172.239197, -800.002014, 913.003052 } } } },

    /** Patch 73 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -67.053001, -800.002014, 725.025024 },
                { -147.604797, -670.852722, 665.175659 },
                { -25.356800, -800.002014, 745.317932 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -113.862701, -658.100830, 679.557190 },
                { -25.356800, -800.002014, 745.317932 },
                { -147.604797, -670.852722, 665.175659 } } } },

    /** Patch 74 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -126.785400, -800.002014, 926.576050 },
                { -25.356800, -800.002014, 745.317932 },
                { -244.124313, -658.100830, 912.344971 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -113.862701, -658.100830, 679.557190 },
                { -244.124313, -658.100830, 912.344971 },
                { -25.356800, -800.002014, 745.317932 } } } },

    /** Patch 75 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -185.036591, -766.667969, 883.266968 },
                { -102.610901, -766.667969, 735.966003 },
                { -623.555115, -766.667969, 679.991882 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -571.348389, -766.667969, 586.693787 },
                { -623.555115, -766.667969, 679.991882 },
                { -102.610901, -766.667969, 735.966003 } } } },

    /** Patch 76 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -641.077515, -800.002014, 671.869080 },
                { -161.664307, -800.002014, 894.102966 },
                { -623.555115, -766.667969, 679.991882 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -185.036591, -766.667969, 883.266968 },
                { -623.555115, -766.667969, 679.991882 },
                { -161.664307, -800.002014, 894.102966 } } } },

    /** Patch 77 **/
    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -77.628601, -800.002014, 743.924988 },
                { -590.078308, -800.002014, 580.729065 },
                { -102.610901, -766.667969, 735.966003 } } } },

    { MODEL_TRIANGLE,
        { { 0.506699, 0.690953, 0.552763 }, { 0.000000, 0.000000, 0.000000 },
            { { -571.348389, -766.667969, 586.693787 },
                { -102.610901, -766.667969, 735.966003 },
                { -590.078308, -800.002014, 580.729065 } } } },




    { MODEL_NULL } } ;

