#!/bin/bash
#
# generate.sh
# ===========
# (C) Jean-Pierre Lozi, 2013
#

. ../../../figures/bench.inc.sh

CACHE_MISS_TYPE="L2"
MACHINES=("amd48b" "amd48b" "niagara2" "niagara2")
X_RANGES=("0:10" "0:30" "0:10" "0:30")
X_TICSS=("2" "4" "2" "4")
X_TITLES=("Number of local cache lines accessed without prefetching" "Number of context variables"
          "Number of local cache lines accessed without prefetching" "Number of context variables")
Y_RANGES=("5000:1000000" "5000:1000000" "10000:100000000" "10000:100000000")
KEY_LOCATIONS=("2000000,300000000" "2000000,300000000" "2000000,300000000" "2000000,300000000")
TAGS=("220817-context-variables" "220817-context-variables-packed" "220817-context-variables" "220817-context-variables-packed")
SHORT_TAGS=("context-variables" "context-variables-packed" "context-variables" "context-variables-packed")
N_RUNS=5

function replace_variable
{
    VARIABLE_NAME=$1
    VARIABLE=${!VARIABLE_NAME}

    cat tmp.plt | sed "s/@@$VARIABLE_NAME@@/$VARIABLE/g"             \
        > tmp-tmp.plt

    mv tmp-tmp.plt tmp.plt
}


for MACHINE_ID in ${!MACHINES[*]}
do

    MACHINE=${MACHINES[$MACHINE_ID]}
    TAG=${TAGS[$MACHINE_ID]}
    SHORT_TAG=${SHORT_TAGS[$MACHINE_ID]}

    OUTPUT_PREFIX="output/var-microbenchmark-"$SHORT_TAG"-"
    RESULTS_PATH="../../all-results/results-$TAG-$MACHINE/"

    RESULTS_PATH=$(echo $RESULTS_PATH | sed 's/\//\\\//g')

    N_EXPERIMENTS=${#TAGS[@]}
    X_RANGE=${X_RANGES[$MACHINE_ID]}
    X_TICS=${X_TICSS[$MACHINE_ID]}
    X_TITLE=${X_TITLES[$MACHINE_ID]}
    Y_RANGE=${Y_RANGES[$(($MACHINE_ID))]}
    KEY_LOCATION=${KEY_LOCATIONS[$(($MACHINE_ID))]}

    for KEY in ""
    do

        cat var-base-no-key.plt > tmp.plt

        replace_variable N_RUNS
        replace_variable RESULTS_PATH
        replace_variable CACHE_MISS_TYPE
        replace_variable X_RANGE
        replace_variable X_TICS
        replace_variable X_TITLE
        replace_variable Y_RANGE
        replace_variable KEY_LOCATION

        replace_variable POSIX_SETTINGS
        replace_variable SPINLOCK_SETTINGS
        replace_variable MCS_SETTINGS
        replace_variable MCSTP_SETTINGS
        replace_variable FLAT_SETTINGS
        replace_variable CCSYNCH_SETTINGS
        replace_variable DSMSYNCH_SETTINGS
        replace_variable RCL_SETTINGS

        cat tmp.plt | LC_ALL="en_US.UTF-8" LC_NUMERIC="en_US.UTF-8" gnuplot \
            > ${OUTPUT_PREFIX}${MACHINE}.pdf

        rm tmp.plt

    done

done

#for KEY in "key" "key-wide"
#do
#
#    cat ${KEY}.plt > tmp.plt
#
#    replace_variable POSIX_SETTINGS
#    replace_variable SPINLOCK_SETTINGS
#    replace_variable MCS_SETTINGS
#    replace_variable MCSTP_SETTINGS
#    replace_variable FLAT_SETTINGS
#    replace_variable CCSYNCH_SETTINGS
#    replace_variable DSMSYNCH_SETTINGS
#    replace_variable RCL_SETTINGS
#
#    cat tmp.plt | gnuplot > output/${KEY}.pdf 2> /dev/null
#
#    rm tmp.plt
#
#done

