#!/usr/bin/gnuplot -persist
#
#
#    	G N U P L O T
#    	Version 4.6 patchlevel 0    last modified 2012-03-04
#    	Build System: Linux x86_64
#
#    	Copyright (C) 1986-1993, 1998, 2004, 2007-2012
#    	Thomas Williams, Colin Kelley and many others
#
#    	gnuplot home:     http://www.gnuplot.info
#    	faq, bugs, etc:   type "help FAQ"
#    	immediate help:   type "help"  (plot window: hit 'h')
set terminal pdfcairo transparent enhanced dashed font "Helvetica, 13" fontscale 0.5 dashed size 7.00in, 1.50in
set output 'output/var-microbenchmark-h-parameter.pdf'
unset clip points
set clip one
unset clip two
set bar 1.000000 front
set border 31 front linetype -1 linewidth 1.000
set timefmt z "%d/%m/%y,%H:%M"
set zdata
set timefmt y "%d/%m/%y,%H:%M"
set ydata
set timefmt x "%d/%m/%y,%H:%M"
set xdata
set timefmt cb "%d/%m/%y,%H:%M"
set timefmt y2 "%d/%m/%y,%H:%M"
set y2data
set timefmt x2 "%d/%m/%y,%H:%M"
set x2data
set boxwidth
set style fill  empty border
set style rectangle back fc lt -3 fillstyle   solid 1.00 border lt -1
set style circle radius graph 0.02, first 0, 0
set style ellipse size graph 0.05, 0.03, first 0 angle 0 units xy
set dummy x,y
set format x "% g"
set format y "%'g"
set format x2 "% g"
set format y2 "% g"
set format z "% g"
set format cb "% g"
set format r "% g"
set angles radians
unset grid
set raxis
set key title ""
#set key inside right top vertical Right noreverse enhanced autotitles box
#set key noinvert samplen 4 spacing 1 width 0 height 0
#set key maxcolumns 0 maxrows 0
#set key noopaque
set key top right inside box
set style increment default
unset style line
unset style arrow
set style histogram clustered gap 2 title  offset character 0, 0, 0
unset logscale y
set offsets 0, 0, 0, 0
set pointsize 1
set pointintervalbox 1
set encoding default
unset polar
unset parametric
unset decimalsign
set view 60, 30, 1, 1
set samples 100, 100
set isosamples 10, 10
set surface
unset contour
set clabel '%8.3g'
set mapping cartesian
set datafile separator ","
unset hidden3d
set cntrparam order 4
set cntrparam linear
set cntrparam levels auto 5
set cntrparam points 5
set size ratio 0 1,1
set origin 0,0
set style data points
set style function lines
set xzeroaxis linetype -2 linewidth 1.000
set yzeroaxis linetype -2 linewidth 1.000
set zzeroaxis linetype -2 linewidth 1.000
set x2zeroaxis linetype -2 linewidth 1.000
set y2zeroaxis linetype -2 linewidth 1.000
set mxtics default
set mytics default
set mztics default
set mx2tics default
set my2tics default
set mcbtics default
set xtics border in scale 1,0.5 mirror norotate  offset character 0, 0, 0 autojustify
set xtics autofreq  norangelimit
unset logscale y
set ytics border in scale 1,0.5 mirror norotate  offset character 0, 0, 0 autojustify
set yrange [25000:100000]
set ytics ("25,000" 25000, "50,000" 50000, "75,000" 75000, "100,000" 100000)
set ztics border in scale 1,0.5 nomirror norotate  offset character 0, 0, 0 autojustify
set ztics autofreq  norangelimit
set nox2tics
set noy2tics
set cbtics border in scale 1,0.5 mirror norotate  offset character 0, 0, 0 autojustify
set cbtics autofreq  norangelimit
set rtics axis in scale 1,0.5 nomirror norotate  offset character 0, 0, 0 autojustify
set rtics autofreq  norangelimit
set title ""
set title  offset character 0, 0, 0 font "" norotate
set timestamp bottom
set timestamp ""
set timestamp  offset character 0, 0, 0 font "" norotate
set rrange [ * : * ] noreverse nowriteback
set trange [ * : * ] noreverse nowriteback
set urange [ * : * ] noreverse nowriteback
set vrange [ * : * ] noreverse nowriteback
set xlabel "Maximum number of consecutive critical sections serviced by a combiner"
set xlabel  offset character 0, 0, 0 font "" textcolor lt -1 norotate
set x2label ""
set x2label  offset character 0, 0, 0 font "" textcolor lt -1 norotate
set x2range [ * : * ] noreverse nowriteback
set ylabel "Execution time (cycles)"
set ylabel  offset character 0, 0, 0 font "" textcolor lt -1 rotate by -270
set y2label ""
set y2label  offset character 0, 0, 0 font "" textcolor lt -1 rotate by -270
#set yrange [ * : * ] noreverse nowriteback
set y2range [ * : * ] noreverse nowriteback
set zlabel ""
set zlabel  offset character 0, 0, 0 font "" textcolor lt -1 norotate
set zrange [ * : * ] noreverse nowriteback
set cblabel ""
set cblabel  offset character 0, 0, 0 font "" textcolor lt -1 rotate by -270
set cbrange [ * : * ] noreverse nowriteback
set xrange [ 1 : 512 ]
set logscale x
#unset logscale y
#set xtics 100
#set xtics add 144
#set xtics add 384
set zero 1e-08
set lmargin  -1
set bmargin  -1
set rmargin  -1
set tmargin  -1
set pm3d explicit at s
set pm3d scansautomatic
set pm3d interpolate 1,1 flush begin noftriangles nohidden3d corners2color mean
set palette positive nops_allcF maxcolors 0 gamma 1.5 color model RGB
set palette rgbformulae 7, 5, 15
set colorbox default
set colorbox vertical origin screen 0.9, 0.2, 0 size screen 0.05, 0.6, 0 front bdefault
set style boxplot candles range  1.50 outliers pt 7 separation 1 labels auto unsorted
set loadpath
set fontpath
set psdir
set fit noerrorvariables
GNUTERM = "wxt"
set grid lc rgb "#aaaaaa"
set key maxrows 2
set key width -0.2
set key height +0.35
set arrow from 144,26000 to 144,77500 nohead lc rgb "#AC2B50" lt 2 lw 5
set arrow from 144,98000 to 144,99000 nohead lc rgb "#AC2B50" lt 2 lw 5
set label "144" at 144, 17500 tc rgb "#AC2B50" center font "Helvetica Bold, 11"
set arrow from 384,26000 to 384,77000 nohead lc rgb "#AC2B50" lt 3 lw 5
set arrow from 384,98000 to 384,99000 nohead lc rgb "#AC2B50" lt 3 lw 5
set label "384" at 384, 17500 tc rgb "#AC2B50" center font "Helvetica Bold, 11"
plot "../../all-results/results-140307-phd-h-parameter-amd48b/var-bench_mci_ccsynch_1.csv" using 1:2:3:4 with errorlines title "CC-Synch, Magnycours-48" lc rgb "#62AA2A" ps 0 pt 16 lw 2 lt 2 axes x1y1, "../../all-results/results-140307-phd-h-parameter-amd48b/var-bench_mci_dsmsynch_1.csv" using 1:2:3:4 with errorlines title "DSM-Synch, Magnycours-48" lc rgb "#4C8521" ps 0 pt 16 lw 2 lt 23 axes x1y1, "../../all-results/results-140307-phd-h-parameter-niagara2/var-bench_mci_ccsynch_1.csv" using 1:2:3:4 with errorlines title "CC-Synch, Niagara2-128" lc rgb "#70428E" ps 0 pt 16 lw 2 lt 2 axes x1y1, "../../all-results/results-140307-phd-h-parameter-niagara2/var-bench_mci_dsmsynch_1.csv" using 1:2:3:4 with errorlines title "DSM-Synch, Niagara2-128" lc rgb "#523069" ps 0 pt 16 lw 2 lt 3 axes x1y1



#    EOF
