#!/bin/bash
#
# benchmark.sh
# ============
# (C) Jean-Pierre Lozi, 2013
#
#
# Examples:
# ---------
# $ PACKED=1 POINTS="`seq 0 30`" ./benchmark_context_variables.sh
# $ PACKED=0 POINTS="`seq 0 10`" ./benchmark_context_variables.sh
#
# On Linux, prefix these commands with sudo.
# Don't forget to specify the N_RUNS.
#

. ../../figures/bench.inc.sh

SCRIPT_NAME=`basename $0`
EXPERIMENT_NAME=context_variables
BENCHMARK=../bin/benchmark

export TOP_PID=$$

if [[ -z $N_RUNS ]];       then N_RUNS=5;                                     fi
if [[ -z $N_SAMPLES ]];    then N_SAMPLES=50;                                 fi
if [[ -z $N_ITERATIONS ]]; then N_ITERATIONS=10000;                           fi
if [[ -z $MIN ]];          then MIN=100;                                      fi
if [[ -z $MAX ]];          then MAX=2000000;                                  fi
if [[ -z $ACCESSES ]];     then ACCESSES="1";                                 fi
if [[ -z $PACKED ]];       then PACKED=0;                                     fi
if [[ -z $BENCHES ]]
then
    BENCHES="rcl mcs posix mcstp flat ccsynch dsmsynch spinlock"
fi
if [[ -z $POINTS ]]
then
    POINTS=`seq 0 30`
fi

rm -Rf ../results/$SCRIPT_NAME* >/dev/null 1>&0
mkdir -p ../results

echo "Experiment =" $EXPERIMENT_NAME


if [[ $(uname) != "SunOS" && "$(id -u)" != "0" ]]
then
    echo "Must be root"
    exit 1
fi


function measure
{
    DELAY=100
    C=$1;G=$2;L=$3
    shift 3
    I=1

    if [[ "$Z" = "-1" ]]
    then
        if [[ "$(hostname)" = amd48b* ]]
        then
            Z=8
            D="-x dependent"
        elif [[ "$(hostname)" = niagara2* ]]
        then
            # Z=12
            # This is actually faster on niagara2...
            Z=0
            # Works better for eluding niagara2's prefetcher...
            D="-x permutations"
        fi
    fi

    P=""

    if [[ ! $PACKED -eq 0 ]]
    then
        P="-P"
    fi

    for L in $POINTS
    do

        echo -n $L
        echo -n ","
        echo -n "scale=6;(" > ../results/sum
        echo -n > ../results/list

        J=1

        while [[ J -le $N_RUNS ]]
        do

                $BENCHMARK -m -1 -n $N_ITERATIONS -d $DELAY                    \
                -A 1 -c $C -s 1 -u -D -g $G -l $L -z $Z $P $D $@ 2> /dev/null  \
                | tr -d ',\n' | tee -a ../results/sum ../results/list          \
                >> /dev/null

            if [[ $J -lt $N_RUNS ]]
            then
                echo -n '+' >> ../results/sum
                echo -n ',' >> ../results/list
            fi

            ((J++))

        done

        echo ")/$N_RUNS" >> ../results/sum
        cat ../results/sum | bc | tr -d '\n'
        echo -n ","
        cat ../results/list
        echo

        ((I++))

    done
}


function apply
{
    I=$1
    N=$3
    F=$5

    if [[ -z "$N_CORES" ]]
    then
        if [[ $(uname) == "SunOS" ]]
        then
            C=`kstat cpu_info | grep "instance" | wc -l | tr -d ' '`
        else
            C=`cat /proc/cpuinfo | grep "processor" | wc -l`
        fi
    else
        C=$N_CORES
    fi

    C=$(($C-1))

    if [[ "$N" == "RCL" ]]
    then
        C=$(($C-1))
    fi

    shift 7
    echo "$N, $I shared variables ($C threads)"
    echo "====================================================================="

    SUFFIX=""

#    if [[ ! $PACKED -eq 0 ]]
#    then
#        SUFFIX="_packed"
#    fi

    measure $C $I 0 $@ -o -N \
        | tee ../results/${EXPERIMENT_NAME}_${F}_${I}_0_${N_RUNS}${SUFFIX}.csv
}


if [[ $(uname) = "Linux" ]]
then
    sudo sysctl -w vm.nr_hugepages=2000
fi

Z=-1

for I in $ACCESSES
do
    for B in $BENCHES; do
        on_bench $B apply $I
        rm -rf ../results/sum
        rm -rf ../results/list
    done
done

if [[ $(uname) = "Linux" ]]
then
    sudo sysctl -w vm.nr_hugepages=0
fi

# echo -e "Subject: amd48 ../results\n\nLoop ${LOOPINFO} done." \
#     | /usr/sbin/ssmtp jp.lozi@gmail.com

