/* ########################################################################## */
/* liblock_cs.c                                                               */
/* (C) Jean-Pierre Lozi, 2010-2011                                            */
/* (C) Gaël Thomas, 2010-2011                                                 */
/* -------------------------------------------------------------------------- */
/* ########################################################################## */
#include "liblock_cs.h"

#include <papi.h>
#include <pthread.h>
#include "cs.h"
#include "liblock.h"
#include "liblock-fatal.h"

#define MAX_LIBLOCK_LOCKS 10

#if !defined(NO_PAPI) && !defined(__sun__)
static int g_event_set = PAPI_NULL;
#endif
static volatile int g_events_monitored_server = -1;
static volatile int g_events_number_of_threads = 0;

const char*          g_liblock_name = 0;
liblock_lock_t       g_liblock_lock;
liblock_lock_t       g_liblock_locks[MAX_LIBLOCK_LOCKS];

void *liblock_cs(void *context_variables_local_memory_area)
{
    access_variables(context_variables_local_memory_area,
                     0,
                     g_number_of_context_variables,
                     g_access_order,
                     g_local_permutations_array);

    access_variables(g_shared_variables_memory_area,
                     0,
                     g_number_of_shared_variables,
                     g_access_order,
                     g_global_permutations_array);

    return NULL;
}


void* liblock_cs_g1(void *context_variables_local_memory_area)
{
    access_variables(context_variables_local_memory_area,
                     0,
                     g_number_of_context_variables,
                     g_access_order,
                     g_local_permutations_array);


    (*g_shared_variables_memory_area)++;

    return NULL;
}

void* liblock_cs_packed_g1(void *context_variables_local_memory_area)
{
    int i;
    volatile uint32_t *context_storage = context_variables_local_memory_area;
    volatile uint32_t *mailbox_storage = g_number_of_mailbox_variables > 0 ?
                                         get_mailbox_storage_address() : NULL;

    if (mailbox_storage)
    {
        for (i = 0; i < g_number_of_mailbox_variables; i++)
            mailbox_storage[i]++;

        for (; i < g_number_of_context_variables; i++)
            context_storage[i]++;
    }
    else
    {
        for (i = 0; i < g_number_of_context_variables; i++)
            context_storage[i]++;
    }

    (*g_shared_variables_memory_area)++;

    return NULL;
}


void *liblock_cs_g1l0_dependent(void *context_variables_local_memory_area)
{
    (*g_shared_variables_memory_area)++;

    return NULL;
}

void *liblock_cs_g5l0_dependent(void *context_variables_local_memory_area)
{
    int i = 0;

    volatile uint64_t *memory_area = g_shared_variables_memory_area;

/*
    for (k = 0; k < 5; k++)
    {
        i = (*(volatile uint64_t *)((uintptr_t)memory_area +
                                    k * 2 * sizeof(cache_line_t) +
                                    (i % 2) * sizeof(uint64_t)))++;
    }
*/

    i = (*(volatile uint64_t *)((uintptr_t)memory_area))++;

    i = (*(volatile uint64_t *)((uintptr_t)memory_area +
                                2 * sizeof(cache_line_t) +
                                (i % 2) * sizeof(uint64_t)))++;

    i = (*(volatile uint64_t *)((uintptr_t)memory_area +
                                4 * sizeof(cache_line_t) +
                                (i % 2) * sizeof(uint64_t)))++;

    i = (*(volatile uint64_t *)((uintptr_t)memory_area +
                                6 * sizeof(cache_line_t) +
                                (i % 2) * sizeof(uint64_t)))++;

    i = (*(volatile uint64_t *)((uintptr_t)memory_area +
                                8 * sizeof(cache_line_t) +
                                (i % 2) * sizeof(uint64_t)))++;

    return NULL;
}

void* liblock_cs_recursive(void *_depth)
{
    intptr_t depth = (intptr_t)_depth;

    if (depth < 0)
        (*g_shared_variables_memory_area)++;
    else
        liblock_exec(&g_liblock_locks[depth], &liblock_cs_recursive,
                     (void *)(depth - 1));

    return NULL;
}

void server_started()
{
    g_server_started = 1;
}

void liblock_on_server_thread_start(const char* lib, unsigned int thread_id)
{
#if !defined(NO_PAPI) && !defined(__sun__)
    long long values[1];

    PAPI_thread_init((unsigned long (*)(void))pthread_self);
#endif

    if (g_monitored_event_id != 0)
    {
        if(__sync_val_compare_and_swap(&g_events_monitored_server,
                                       -1,
                                       self.running_hw_thread->hw_thread_id))
        {
#if !defined(NO_PAPI) && !defined(__sun__)
            if(PAPI_create_eventset(&g_event_set) != PAPI_OK)
                warning("PAPI_create_eventset");
            else if(PAPI_add_event(g_event_set,
                                   g_monitored_event_id) != PAPI_OK)
                warning("PAPI_add_events");
            /* This seemingly helps increasing PAPI's accuracy. */
            else
            {
                if(PAPI_start(g_event_set) != PAPI_OK)
                    warning("PAPI_start");
                if (PAPI_stop(g_event_set, values) != PAPI_OK)
                    warning("PAPI_stop");
                if (PAPI_start(g_event_set) != PAPI_OK)
                    warning("PAPI_start");
            }
#endif
        }
        if(g_events_monitored_server == self.running_hw_thread->hw_thread_id)
            __sync_fetch_and_add(&g_events_number_of_threads, 1);
    }
}

void liblock_on_server_thread_end(const char* lib, unsigned int thread_id)
{
#if !defined(NO_PAPI) && !defined(__sun__)
    long long values[1];
#endif

    if (g_monitored_event_id != 0
            && g_events_monitored_server == self.running_hw_thread->hw_thread_id
            && !__sync_sub_and_fetch(&g_events_number_of_threads, 1)) {

#if !defined(NO_PAPI) && !defined(__sun__)
        if(PAPI_stop(g_event_set, values) != PAPI_OK)
            warning("PAPI_stop");
        else
            g_event_count = values[0];
#endif
    }
}

struct hw_thread* get_core(unsigned int physical_core)
{
    return &topology->
               hw_threads[g_physical_to_virtual_hw_thread_id[physical_core]];
}

/* Don't print stats. */
void liblock_print_stats() {}

/* Avoid useless warning from libnuma. */
void numa_warn(int number, char *where, ...) {}

