#benchs="rcl"
benchs="rcl posix spinlock mcs flat"
#benchs="mcsmit mcs"

bench_definitions=(
    'posix'         'POSIX'          '[posix] liblock: '           'gl_posix' 'lc rgb "#009400" lt 4 pt 13'     'lc rgb "#94ff94" lt 4 pt 12'     '-F posix'
    'spinlock'      'Spinlock'       '[spinlock] liblock: '        'gl_sl'    'lc rgb "#000094" lt 3 pt 1'      'lc rgb "#9494ff" lt 3 pt 2'      '-F spinlock'
    'spinlockb'     'Spinlock'       '[spinlock] bench: '          '?'        '?'                               '?'                               '-L'
    'mcsmit'        'MCSMIT'         '[mcsmit] liblock: '          'gl_mcs_mit' 'lc rgb "#940094" lt 2 pt 7'      'lc rgb "#8beded" lt 2 pt 6'      '-F mcsmit'
    'mcs'           'MCS'            '[mcs] liblock: '             'gl_mcsl'  'lc rgb "#009494" lt 2 pt 9'      'lc rgb "#8beded" lt 2 pt 8'      '-F mcs'
    'mcsb'          'MCS'            '[mcs] bench: '               '?'        '?'                               '?'                               '-M'
    'flat'          'Flat Combining' '[flat combining] liblock: '  'gl_fc'    'lc rgb "#944a00" lt 5 pt 5'      'lc rgb "#ffc994" lt 5 pt 4'      '-F flat'
    'rclb'          'RCL'            '[rclb] bench: '              '?'        '?'                               '?'                               '-m -o'
    'rcl'           'RCL'            '[rcl] liblock: '             'gl_rcl'   'lc rgb "#940000" lt 1 pt 7' 'lc rgb "#ff9494" lt 1 pt 6' '-F rcl'
    'multircl'      'MULTIRCL'       '[multircl] liblock: '        'gl_multircl' 'lc rgb "#940000" lt 1 pt 7' 'lc rgb "#ff9494" lt 1 pt 6' '-F multircl'
)

on_bench() {
		bench=$1
    shift
    let N=0
		F=0
		
    while [ $N -lt ${#bench_definitions[*]} ]; do
				if [ ${bench_definitions[$N]} = $bench ]; then
						$@ "${bench_definitions[$N]}" "${bench_definitions[$N+1]}" "${bench_definitions[$N+2]}" "${bench_definitions[$N+3]}" "${bench_definitions[$N+4]}" "${bench_definitions[$N+5]}" ${bench_definitions[$N+6]}
						F=1
				fi
        let N=$N+7
    done

		if [ $F = 0 ]; then
				echo "FATAL: unable to find benchmark '$bench'"
				exit 42
		fi
}

gen_var() {
		point=$1
		let T=0
		A=0
		V=0
		while read line; do
				let T=$T+1
				A="$A+$line"
				V="$V+($line - a)^2"
		done
		avg=$(echo "($A)/$T" | bc -l)
		var=$(echo "a=$avg; sqrt($V)" | bc -l)
		echo "$point,$avg,$var"
}

