/* ########################################################################## */
/* (C) UPMC, 2010-2011                                                        */
/*     Authors:                                                               */
/*       Jean-Pierre Lozi <jean-pierre.lozi@lip6.fr>                          */
/*       Gaël Thomas <gael.thomas@lip6.fr>                                    */
/*       Florian David <florian.david@lip6.fr>                                */
/*       Julia Lawall <julia.lawall@lip6.fr>                                  */
/*       Gilles Muller <gilles.muller@lip6.fr>                                */
/* -------------------------------------------------------------------------- */
/* ########################################################################## */
#include <string.h>
#include <errno.h>
#include "liblock-fatal.h"
#include "liblock.h"

struct liblock_lock {
	declare_liblock_lock_header();
	char            pad0[pad_to_cache_line(sizeof(struct liblock_lock_header))];
	unsigned int volatile      lock;
	//char            pad1[pad_to_cache_line(sizeof(unsigned int))];
	pthread_mutex_t posix_lock;
};

static struct liblock_lock* do_liblock_create_lock(spinlock)(struct liblock* lib, struct core* server, pthread_mutexattr_t* attr) {
	struct liblock_lock* res = liblock_allocate(sizeof(struct liblock_lock));

	res->lock = 0;
	res->lib = lib;
	pthread_mutex_init(&res->posix_lock, 0);

	return res;
}

static void do_liblock_destroy_lock(spinlock)(struct liblock_lock* lock) {
	free(lock);
}

static void* do_liblock_execute_operation(spinlock)(struct liblock_lock* lock, void* (*pending)(void*), void* val) {
	void* res;
	while(__sync_val_compare_and_swap(&lock->lock, 0, 1)) {
		PAUSE();
	}
	
	res = pending(val);

	lock->lock = 0;

	return res;
}

static void do_liblock_init_library(spinlock)() {
}

static void do_liblock_kill_library(spinlock)() {
}

static void do_liblock_run(spinlock)(void (*callback)()) {
	if(__sync_val_compare_and_swap(&liblock_start_server_threads_by_hand, 1, 0) != 1)
		fatal("servers are not managed by hand");
	if(callback)
		callback();
}

static int do_liblock_cond_init(spinlock)(liblock_cond_t* cond) { 
	fatal("implement me"); 
}

static int do_liblock_cond_wait(spinlock)(liblock_cond_t* cond, struct liblock_lock* lock) { 
	fatal("implement me"); 
}

static int do_liblock_cond_timedwait(spinlock)(liblock_cond_t* cond, struct liblock_lock* lock, const struct timespec* ts) { 
	fatal("implement me"); 
}

static int do_liblock_cond_signal(spinlock)(liblock_cond_t* cond) { 
	fatal("implement me"); 
}

static int do_liblock_cond_broadcast(spinlock)(liblock_cond_t* cond) { 
	fatal("implement me"); 
}

static int do_liblock_cond_destroy(spinlock)(liblock_cond_t* cond) { 
	fatal("implement me"); 
}

static void do_liblock_on_thread_exit(spinlock)(struct thread_descriptor* desc) {
}

static void do_liblock_on_thread_start(spinlock)(struct thread_descriptor* desc) {
}

static void do_liblock_unlock_in_cs(spinlock)(struct liblock_lock* lock) {
	lock->lock = 0;
}

static void do_liblock_relock_in_cs(spinlock)(struct liblock_lock* lock) {
	while(__sync_val_compare_and_swap(&lock->lock, 0, 1))
		PAUSE();
}

static void do_liblock_declare_server(spinlock)(struct core* core) {
}

liblock_declare(spinlock);
